/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.snakeyaml.engine.kmp.common;

import java.nio.charset.CharacterCodingException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tgbridge.shaded.net.thauvin.erik.urlencoder.UrlEncoderUtil;
import tgbridge.shaded.okio.Buffer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\n\u0010\u0007J\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\r\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ltgbridge/shaded/snakeyaml/engine/kmp/common/UriEncoder;", "", "<init>", "()V", "", "content", "urlDecode", "(Ljava/lang/String;)Ljava/lang/String;", "urlEncode", "uri", "encode", "Ltgbridge/shaded/okio/Buffer;", "buff", "decode", "(Ltgbridge/shaded/okio/Buffer;)Ljava/lang/String;", "SAFE_CHARS", "Ljava/lang/String;", "snakeyaml-engine-kmp"})
public final class UriEncoder {
    @NotNull
    public static final UriEncoder INSTANCE = new UriEncoder();
    @NotNull
    private static final String SAFE_CHARS = "-_.!~*'()@:$&,;=[]/";

    private UriEncoder() {
    }

    private final String urlDecode(String content) {
        return UrlEncoderUtil.decode(content, false);
    }

    private final String urlEncode(String content) {
        return UrlEncoderUtil.encode(content, SAFE_CHARS, false);
    }

    @JvmStatic
    @NotNull
    public static final String encode(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return INSTANCE.urlEncode(uri);
    }

    @JvmStatic
    @NotNull
    public static final String decode(@NotNull Buffer buff) throws CharacterCodingException {
        Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
        String content = StringsKt.decodeToString((byte[])buff.readByteArray());
        return UriEncoder.decode(content);
    }

    @JvmStatic
    @NotNull
    public static final String decode(@NotNull String buff) {
        Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
        return INSTANCE.urlDecode(buff);
    }
}

