/*
 * Decompiled with CFR 0.152.
 */
package dev.vanutp.tgbridge.forge;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.vanutp.tgbridge.common.models.TgbridgeAdvancementEvent;
import dev.vanutp.tgbridge.common.models.TgbridgeDeathEvent;
import dev.vanutp.tgbridge.common.models.TgbridgeJoinEvent;
import dev.vanutp.tgbridge.common.models.TgbridgeLeaveEvent;
import dev.vanutp.tgbridge.common.models.TgbridgeMcChatMessageEvent;
import dev.vanutp.tgbridge.common.models.TgbridgePlayer;
import dev.vanutp.tgbridge.forge.IHasPlayedBefore;
import dev.vanutp.tgbridge.forge.NeoForgeTelegramBridge;
import dev.vanutp.tgbridge.forge.UtilsKt;
import java.util.Locale;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003J\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u0003J\u001d\u0010\u000f\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0003\u00a8\u0006\u0013"}, d2={"Ldev/vanutp/tgbridge/forge/EventManager;", "", "<init>", "()V", "", "register", "registerChatMessageListener", "registerPlayerDeathListener", "registerPlayerJoinListener", "registerPlayerLeaveListener", "registerPlayerAdvancementListener", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/commands/CommandSourceStack;", "ctx", "", "onReloadCommand", "(Lcom/mojang/brigadier/context/CommandContext;)I", "onToggleMuteCommand", "registerCommandHandlers", "tgbridge-neoforge-1.21"})
@SourceDebugExtension(value={"SMAP\nEventManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventManager.kt\ndev/vanutp/tgbridge/forge/EventManager\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/neoforge/forge/ForgeKt\n*L\n1#1,114:1\n17#2:115\n17#2:116\n17#2:117\n17#2:118\n17#2:119\n17#2:120\n*S KotlinDebug\n*F\n+ 1 EventManager.kt\ndev/vanutp/tgbridge/forge/EventManager\n*L\n27#1:115\n37#1:116\n52#1:117\n61#1:118\n67#1:119\n98#1:120\n*E\n"})
public final class EventManager {
    @NotNull
    public static final EventManager INSTANCE = new EventManager();

    private EventManager() {
    }

    public final void register() {
        this.registerChatMessageListener();
        this.registerPlayerDeathListener();
        this.registerPlayerJoinListener();
        this.registerPlayerLeaveListener();
        this.registerPlayerAdvancementListener();
        this.registerCommandHandlers();
    }

    private final void registerChatMessageListener() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(EventManager::registerChatMessageListener$lambda$0);
    }

    private final void registerPlayerDeathListener() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(EventManager::registerPlayerDeathListener$lambda$1);
    }

    private final void registerPlayerJoinListener() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(EventManager::registerPlayerJoinListener$lambda$2);
    }

    private final void registerPlayerLeaveListener() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(EventManager::registerPlayerLeaveListener$lambda$3);
    }

    private final void registerPlayerAdvancementListener() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(EventManager::registerPlayerAdvancementListener$lambda$4);
    }

    private final int onReloadCommand(CommandContext<CommandSourceStack> ctx) {
        boolean res = NeoForgeTelegramBridge.INSTANCE.onReloadCommand(UtilsKt.toTgbridge(ctx));
        return res ? 1 : -1;
    }

    private final int onToggleMuteCommand(CommandContext<CommandSourceStack> ctx) {
        boolean res = NeoForgeTelegramBridge.INSTANCE.onToggleMuteCommand(UtilsKt.toTgbridge(ctx));
        return res ? 1 : -1;
    }

    private final void registerCommandHandlers() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(EventManager::registerCommandHandlers$lambda$6);
    }

    private static final void registerChatMessageListener$lambda$0(ServerChatEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ServerPlayer serverPlayer = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        TgbridgePlayer tgbridgePlayer = UtilsKt.toTgbridge((Player)serverPlayer);
        Component component = e.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getMessage(...)");
        NeoForgeTelegramBridge.INSTANCE.onChatMessage(new TgbridgeMcChatMessageEvent(tgbridgePlayer, UtilsKt.toAdventure(component), e, null, 8, null));
    }

    private static final void registerPlayerDeathListener$lambda$1(LivingDeathEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LivingEntity player = e.getEntity();
        if (!(player instanceof Player)) {
            return;
        }
        Component deathMessage = e.getSource().getLocalizedDeathMessage(player);
        TgbridgePlayer tgbridgePlayer = UtilsKt.toTgbridge((Player)player);
        Intrinsics.checkNotNull((Object)deathMessage);
        NeoForgeTelegramBridge.INSTANCE.onPlayerDeath(new TgbridgeDeathEvent(tgbridgePlayer, UtilsKt.toAdventure(deathMessage), e, null, 8, null));
    }

    private static final void registerPlayerJoinListener$lambda$2(PlayerEvent.PlayerLoggedInEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Player player = e.getEntity();
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type dev.vanutp.tgbridge.forge.IHasPlayedBefore");
        boolean hasPlayedBefore = ((IHasPlayedBefore)player).tgbridge$getHasPlayedBefore();
        Player player2 = e.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getEntity(...)");
        NeoForgeTelegramBridge.INSTANCE.onPlayerJoin(new TgbridgeJoinEvent(UtilsKt.toTgbridge(player2), hasPlayedBefore, e, null, false, 24, null));
    }

    private static final void registerPlayerLeaveListener$lambda$3(PlayerEvent.PlayerLoggedOutEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Player player = e.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        NeoForgeTelegramBridge.INSTANCE.onPlayerLeave(new TgbridgeLeaveEvent(UtilsKt.toTgbridge(player), e, null, false, 12, null));
    }

    private static final void registerPlayerAdvancementListener$lambda$4(AdvancementEvent.AdvancementEarnEvent e) {
        Object object;
        DisplayInfo display;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Advancement advancement = e.getAdvancement().value();
                Optional optional = advancement.display();
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"display(...)");
                display = (DisplayInfo)OptionalsKt.getOrNull((Optional)optional);
                if (display == null || !display.shouldAnnounceChat()) {
                    return;
                }
                object = display.getType();
                if (object == null || (object = object.name()) == null) break block4;
                String string = ((String)object).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                object = string;
                if (string != null) break block5;
            }
            return;
        }
        Object type = object;
        Player player = e.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        TgbridgePlayer tgbridgePlayer = UtilsKt.toTgbridge(player);
        Component component = display.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getTitle(...)");
        tgbridge.shaded.kyori.adventure.text.Component component2 = UtilsKt.toAdventure(component);
        Component component3 = display.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"getDescription(...)");
        NeoForgeTelegramBridge.INSTANCE.onPlayerAdvancement(new TgbridgeAdvancementEvent(tgbridgePlayer, (String)type, component2, UtilsKt.toAdventure(component3), e, null, 32, null));
    }

    private static final boolean registerCommandHandlers$lambda$6$lambda$5(CommandSourceStack it) {
        return it.hasPermission(4);
    }

    private static final void registerCommandHandlers$lambda$6(RegisterCommandsEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tgbridge").then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(EventManager::registerCommandHandlers$lambda$6$lambda$5)).executes(INSTANCE::onReloadCommand))).then(Commands.literal((String)"toggle").executes(INSTANCE::onToggleMuteCommand)));
    }
}

