/*
 * Decompiled with CFR 0.152.
 */
package dev.vanutp.tgbridge.forge;

import dev.vanutp.tgbridge.common.IPlatform;
import dev.vanutp.tgbridge.common.MuteService;
import dev.vanutp.tgbridge.common.models.TgbridgePlayer;
import dev.vanutp.tgbridge.forge.UtilsKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\r8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001f\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Ldev/vanutp/tgbridge/forge/NeoForgePlatform;", "Ldev/vanutp/tgbridge/common/IPlatform;", "<init>", "()V", "Ltgbridge/shaded/kyori/adventure/text/Component;", "text", "", "broadcastMessage", "(Ltgbridge/shaded/kyori/adventure/text/Component;)V", "", "Ldev/vanutp/tgbridge/common/models/TgbridgePlayer;", "getOnlinePlayers", "()Ljava/util/List;", "", "key", "getLanguageKey", "(Ljava/lang/String;)Ljava/lang/String;", "modId", "", "isModLoaded", "(Ljava/lang/String;)Z", "", "player", "playerToTgbridge", "(Ljava/lang/Object;)Ldev/vanutp/tgbridge/common/models/TgbridgePlayer;", "name", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "configDir", "Ljava/nio/file/Path;", "getConfigDir", "()Ljava/nio/file/Path;", "tgbridge-neoforge-1.21"})
@SourceDebugExtension(value={"SMAP\nNeoForgePlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NeoForgePlatform.kt\ndev/vanutp/tgbridge/forge/NeoForgePlatform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n827#2:47\n855#2,2:48\n1557#2:50\n1628#2,3:51\n*S KotlinDebug\n*F\n+ 1 NeoForgePlatform.kt\ndev/vanutp/tgbridge/forge/NeoForgePlatform\n*L\n20#1:47\n20#1:48,2\n30#1:50\n30#1:51,3\n*E\n"})
public final class NeoForgePlatform
implements IPlatform {
    @NotNull
    private final String name;
    private final Path configDir = FMLPaths.CONFIGDIR.get().resolve("tgbridge");

    public NeoForgePlatform() {
        this.name = "forge";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public Path getConfigDir() {
        return this.configDir;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void broadcastMessage(@NotNull tgbridge.shaded.kyori.adventure.text.Component text) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer currentServer = minecraftServer;
        PlayerList playerManager = currentServer.getPlayerList();
        List list = playerManager.getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayerList(...)");
        Iterable $this$filterNot$iv = list;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ServerPlayer it = (ServerPlayer)element$iv$iv;
            boolean bl = false;
            UUID uUID = it.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
            if (MuteService.INSTANCE.isMuted(uUID)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List players = (List)destination$iv$iv;
        Component message = UtilsKt.toMinecraft(text);
        currentServer.sendSystemMessage(message);
        for (ServerPlayer player : players) {
            player.sendSystemMessage(message, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TgbridgePlayer> getOnlinePlayers() {
        List list;
        List list2;
        PlayerList playerList;
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        if (minecraftServer != null && (playerList = minecraftServer.getPlayerList()) != null && (list2 = playerList.getPlayers()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ServerPlayer serverPlayer = (ServerPlayer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(UtilsKt.toTgbridge((Player)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public String getLanguageKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Language $this$getLanguageKey_u24lambda_u242 = Language.getInstance();
        boolean bl = false;
        return $this$getLanguageKey_u24lambda_u242.has(key) ? $this$getLanguageKey_u24lambda_u242.getOrDefault(key) : null;
    }

    @Override
    public boolean isModLoaded(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        return ModList.get().isLoaded(modId);
    }

    @Override
    @NotNull
    public TgbridgePlayer playerToTgbridge(@NotNull Object player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return UtilsKt.toTgbridge((Player)player);
    }

    @Override
    public boolean isModLoadedMulti(@Nullable String fabricId, @Nullable String forgeId, @Nullable String paperId) {
        return IPlatform.DefaultImpls.isModLoadedMulti(this, fabricId, forgeId, paperId);
    }
}

