/*
 * Decompiled with CFR 0.152.
 */
package dev.vanutp.tgbridge.forge;

import com.google.gson.Gson;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.vanutp.tgbridge.common.TelegramBridge;
import dev.vanutp.tgbridge.forge.EventManager;
import dev.vanutp.tgbridge.forge.NeoForgeLogger;
import dev.vanutp.tgbridge.forge.NeoForgePlatform;
import dev.vanutp.tgbridge.forge.compat.IncompatibleChatModCompat;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.kotlinforforge.neoforge.KotlinModLoadingContext;

@Mod(value="tgbridge")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u00128\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u00178\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010!\u001a\u00020\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Ldev/vanutp/tgbridge/forge/NeoForgeTelegramBridge;", "Ldev/vanutp/tgbridge/common/TelegramBridge;", "<init>", "()V", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/commands/CommandSourceStack;", "ctx", "", "onDumpLangCommand", "(Lcom/mojang/brigadier/context/CommandContext;)I", "Lnet/neoforged/fml/event/lifecycle/FMLClientSetupEvent;", "event", "", "onClientSetup", "(Lnet/neoforged/fml/event/lifecycle/FMLClientSetupEvent;)V", "", "MOD_ID", "Ljava/lang/String;", "Ldev/vanutp/tgbridge/forge/NeoForgeLogger;", "logger", "Ldev/vanutp/tgbridge/forge/NeoForgeLogger;", "getLogger", "()Ldev/vanutp/tgbridge/forge/NeoForgeLogger;", "Ldev/vanutp/tgbridge/forge/NeoForgePlatform;", "platform", "Ldev/vanutp/tgbridge/forge/NeoForgePlatform;", "getPlatform", "()Ldev/vanutp/tgbridge/forge/NeoForgePlatform;", "Lnet/minecraft/core/HolderLookup$Provider;", "registryManager$delegate", "Lkotlin/Lazy;", "getRegistryManager", "()Lnet/minecraft/core/HolderLookup$Provider;", "registryManager", "tgbridge-neoforge-1.21"})
@SourceDebugExtension(value={"SMAP\nNeoForgeTelegramBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NeoForgeTelegramBridge.kt\ndev/vanutp/tgbridge/forge/NeoForgeTelegramBridge\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/neoforge/forge/ForgeKt\n*L\n1#1,82:1\n17#2:83\n65#2:84\n37#2:85\n66#2:86\n24#2:87\n68#2:88\n17#2:89\n17#2:90\n17#2:91\n*S KotlinDebug\n*F\n+ 1 NeoForgeTelegramBridge.kt\ndev/vanutp/tgbridge/forge/NeoForgeTelegramBridge\n*L\n68#1:83\n37#1:84\n37#1:85\n37#1:86\n39#1:87\n37#1:88\n44#1:89\n47#1:90\n50#1:91\n*E\n"})
public final class NeoForgeTelegramBridge
extends TelegramBridge {
    @NotNull
    public static final NeoForgeTelegramBridge INSTANCE = new NeoForgeTelegramBridge();
    @NotNull
    public static final String MOD_ID = "tgbridge";
    @NotNull
    private static final NeoForgeLogger logger = new NeoForgeLogger();
    @NotNull
    private static final NeoForgePlatform platform = new NeoForgePlatform();
    @NotNull
    private static final Lazy registryManager$delegate = LazyKt.lazy(NeoForgeTelegramBridge::registryManager_delegate$lambda$0);

    private NeoForgeTelegramBridge() {
    }

    @Override
    @NotNull
    public NeoForgeLogger getLogger() {
        return logger;
    }

    @Override
    @NotNull
    public NeoForgePlatform getPlatform() {
        return platform;
    }

    @NotNull
    public final HolderLookup.Provider getRegistryManager() {
        Lazy lazy = registryManager$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (HolderLookup.Provider)object;
    }

    private final int onDumpLangCommand(CommandContext<CommandSourceStack> ctx) {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve(MOD_ID);
        Intrinsics.checkNotNull((Object)configDir);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(configDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path minecraftLangFile = configDir.resolve("minecraft_lang.json");
        Language language = Language.getInstance();
        Intrinsics.checkNotNull((Object)language, (String)"null cannot be cast to non-null type net.minecraft.client.resource.language.TranslationStorage");
        Map translations = ((ClientLanguage)language).storage;
        Intrinsics.checkNotNull((Object)minecraftLangFile);
        String string = new Gson().toJson((Object)translations);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        PathsKt.writeText$default((Path)minecraftLangFile, (CharSequence)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(NeoForgeTelegramBridge::onDumpLangCommand$lambda$6, false);
        return 1;
    }

    private final void onClientSetup(FMLClientSetupEvent event) {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(NeoForgeTelegramBridge::onClientSetup$lambda$7);
    }

    private static final RegistryAccess.Frozen registryManager_delegate$lambda$0() {
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        return minecraftServer.registryAccess();
    }

    private static final void lambda$5$lambda$2(ServerStartingEvent serverStartingEvent) {
        Intrinsics.checkNotNullParameter((Object)serverStartingEvent, (String)"<unused var>");
        INSTANCE.init();
    }

    private static final void lambda$5$lambda$3(ServerStartedEvent serverStartedEvent) {
        Intrinsics.checkNotNullParameter((Object)serverStartedEvent, (String)"<unused var>");
        INSTANCE.onServerStarted();
    }

    private static final void lambda$5$lambda$4(ServerStoppingEvent serverStoppingEvent) {
        Intrinsics.checkNotNullParameter((Object)serverStoppingEvent, (String)"<unused var>");
        INSTANCE.shutdown();
    }

    private static final Component onDumpLangCommand$lambda$6() {
        return (Component)Component.literal((String)"minecraft_lang.json created");
    }

    private static final void onClientSetup$lambda$7(RegisterClientCommandsEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MOD_ID).then(LiteralArgumentBuilder.literal((String)"dump_lang").executes(INSTANCE::onDumpLangCommand))).then((ArgumentBuilder)LiteralArgumentBuilder.literal((String)"toggle")));
    }

    static {
        boolean $i$f$runForDist = false;
        boolean $i$f$getDIST = false;
        Dist dist = FMLEnvironment.dist;
        Intrinsics.checkNotNullExpressionValue((Object)dist, (String)"dist");
        if (dist == Dist.CLIENT) {
            boolean bl = false;
            boolean $i$f$getMOD_BUS = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::onClientSetup);
        } else {
            boolean bl = false;
            INSTANCE.addIntegration(new IncompatibleChatModCompat(INSTANCE));
            EventManager.INSTANCE.register();
            boolean $i$f$getFORGE_BUS = false;
            IEventBus iEventBus = NeoForge.EVENT_BUS;
            Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
            iEventBus.addListener(NeoForgeTelegramBridge::lambda$5$lambda$2);
            $i$f$getFORGE_BUS = false;
            IEventBus iEventBus2 = NeoForge.EVENT_BUS;
            Intrinsics.checkNotNullExpressionValue((Object)iEventBus2, (String)"EVENT_BUS");
            iEventBus2.addListener(NeoForgeTelegramBridge::lambda$5$lambda$3);
            $i$f$getFORGE_BUS = false;
            IEventBus iEventBus3 = NeoForge.EVENT_BUS;
            Intrinsics.checkNotNullExpressionValue((Object)iEventBus3, (String)"EVENT_BUS");
            iEventBus3.addListener(NeoForgeTelegramBridge::lambda$5$lambda$4);
        }
    }
}

