/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.kyori.adventure.sound;

import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tgbridge.shaded.kyori.adventure.key.Key;
import tgbridge.shaded.kyori.adventure.sound.Sound;
import tgbridge.shaded.kyori.adventure.sound.SoundStopImpl;
import tgbridge.shaded.kyori.examination.Examinable;

@ApiStatus.NonExtendable
public interface SoundStop
extends Examinable {
    @NotNull
    public static SoundStop all() {
        return SoundStopImpl.ALL;
    }

    @NotNull
    public static SoundStop named(final @NotNull Key sound) {
        Objects.requireNonNull(sound, "sound");
        return new SoundStopImpl(null){

            @Override
            @NotNull
            public Key sound() {
                return sound;
            }
        };
    }

    @NotNull
    public static SoundStop named(final @NotNull Sound.Type sound) {
        Objects.requireNonNull(sound, "sound");
        return new SoundStopImpl(null){

            @Override
            @NotNull
            public Key sound() {
                return sound.key();
            }
        };
    }

    @NotNull
    public static SoundStop named(final @NotNull Supplier<? extends Sound.Type> sound) {
        Objects.requireNonNull(sound, "sound");
        return new SoundStopImpl(null){

            @Override
            @NotNull
            public Key sound() {
                return ((Sound.Type)sound.get()).key();
            }
        };
    }

    @NotNull
    public static SoundStop source(@NotNull Sound.Source source2) {
        Objects.requireNonNull(source2, "source");
        return new SoundStopImpl(source2){

            @Override
            @Nullable
            public Key sound() {
                return null;
            }
        };
    }

    @NotNull
    public static SoundStop namedOnSource(final @NotNull Key sound, @NotNull Sound.Source source2) {
        Objects.requireNonNull(sound, "sound");
        Objects.requireNonNull(source2, "source");
        return new SoundStopImpl(source2){

            @Override
            @NotNull
            public Key sound() {
                return sound;
            }
        };
    }

    @NotNull
    public static SoundStop namedOnSource(@NotNull Sound.Type sound, @NotNull Sound.Source source2) {
        Objects.requireNonNull(sound, "sound");
        return SoundStop.namedOnSource(sound.key(), source2);
    }

    @NotNull
    public static SoundStop namedOnSource(final @NotNull Supplier<? extends Sound.Type> sound, @NotNull Sound.Source source2) {
        Objects.requireNonNull(sound, "sound");
        Objects.requireNonNull(source2, "source");
        return new SoundStopImpl(source2){

            @Override
            @NotNull
            public Key sound() {
                return ((Sound.Type)sound.get()).key();
            }
        };
    }

    @Nullable
    public Key sound();

    public @Nullable Sound.Source source();
}

