/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.okhttp3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0014\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\tJ\u001d\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u000f\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0011\u0010\u0004\u001a\u0004\u0018\u00010\u0002H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u0015\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u001b\u0010\u001cR%\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020\u00078G\u00a2\u0006\f\n\u0004\b\b\u0010\u001d\u001a\u0004\b\b\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\f8G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0018R\u0017\u0010\u0003\u001a\u00020\u00028\u0007\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u0003\u0010\u0018\u00a8\u0006\u001f"}, d2={"Ltgbridge/shaded/okhttp3/Challenge;", "", "", "scheme", "realm", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "", "authParams", "(Ljava/lang/String;Ljava/util/Map;)V", "-deprecated_authParams", "()Ljava/util/Map;", "Ljava/nio/charset/Charset;", "-deprecated_charset", "()Ljava/nio/charset/Charset;", "charset", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "-deprecated_realm", "()Ljava/lang/String;", "-deprecated_scheme", "toString", "withCharset", "(Ljava/nio/charset/Charset;)Ltgbridge/shaded/okhttp3/Challenge;", "Ljava/util/Map;", "Ljava/lang/String;", "okhttp"})
public final class Challenge {
    @NotNull
    private final String scheme;
    @NotNull
    private final Map<String, String> authParams;

    public Challenge(@NotNull String scheme, @NotNull Map<String, String> authParams) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter(authParams, (String)"authParams");
        this.scheme = scheme;
        Map newAuthParams = new LinkedHashMap();
        for (Map.Entry<String, String> entry : authParams.entrySet()) {
            String string;
            String key = entry.getKey();
            String value = entry.getValue();
            if (key != null) {
                String string2;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string3 = string2.toLowerCase(locale);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            } else {
                string = null;
            }
            String newKey = string;
            newAuthParams.put(newKey, value);
        }
        Map map = Collections.unmodifiableMap(newAuthParams);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap<String?, String>(newAuthParams)");
        this.authParams = map;
    }

    @JvmName(name="scheme")
    @NotNull
    public final String scheme() {
        return this.scheme;
    }

    @JvmName(name="authParams")
    @NotNull
    public final Map<String, String> authParams() {
        return this.authParams;
    }

    @JvmName(name="realm")
    @Nullable
    public final String realm() {
        return this.authParams.get("realm");
    }

    @JvmName(name="charset")
    @NotNull
    public final Charset charset() {
        String charset = this.authParams.get("charset");
        if (charset != null) {
            try {
                Charset charset2 = Charset.forName(charset);
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
                return charset2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Charset charset3 = StandardCharsets.ISO_8859_1;
        Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"ISO_8859_1");
        return charset3;
    }

    public Challenge(@NotNull String scheme, @NotNull String realm) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Map<String, String> map = Collections.singletonMap("realm", realm);
        Intrinsics.checkNotNullExpressionValue(map, (String)"singletonMap(\"realm\", realm)");
        this(scheme, map);
    }

    @NotNull
    public final Challenge withCharset(@NotNull Charset charset) {
        Map authParams;
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Map map = authParams = MapsKt.toMutableMap(this.authParams);
        String string = "charset";
        String string2 = charset.name();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"charset.name()");
        String string3 = string2;
        map.put(string, string3);
        return new Challenge(this.scheme, authParams);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="scheme", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_scheme")
    @NotNull
    public final String -deprecated_scheme() {
        return this.scheme;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="authParams", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_authParams")
    @NotNull
    public final Map<String, String> -deprecated_authParams() {
        return this.authParams;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="realm", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_realm")
    @Nullable
    public final String -deprecated_realm() {
        return this.realm();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="charset", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_charset")
    @NotNull
    public final Charset -deprecated_charset() {
        return this.charset();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Challenge && Intrinsics.areEqual((Object)((Challenge)other).scheme, (Object)this.scheme) && Intrinsics.areEqual(((Challenge)other).authParams, this.authParams);
    }

    public int hashCode() {
        int result = 29;
        result = 31 * result + this.scheme.hashCode();
        result = 31 * result + ((Object)this.authParams).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return this.scheme + " authParams=" + this.authParams;
    }
}

