/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.okhttp3.internal.connection;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tgbridge.shaded.okhttp3.EventListener;
import tgbridge.shaded.okhttp3.Headers;
import tgbridge.shaded.okhttp3.Request;
import tgbridge.shaded.okhttp3.RequestBody;
import tgbridge.shaded.okhttp3.Response;
import tgbridge.shaded.okhttp3.ResponseBody;
import tgbridge.shaded.okhttp3.internal.connection.ExchangeFinder;
import tgbridge.shaded.okhttp3.internal.connection.RealCall;
import tgbridge.shaded.okhttp3.internal.connection.RealConnection;
import tgbridge.shaded.okhttp3.internal.http.ExchangeCodec;
import tgbridge.shaded.okhttp3.internal.http.RealResponseBody;
import tgbridge.shaded.okhttp3.internal.ws.RealWebSocket;
import tgbridge.shaded.okio.Buffer;
import tgbridge.shaded.okio.ForwardingSink;
import tgbridge.shaded.okio.ForwardingSource;
import tgbridge.shaded.okio.Okio;
import tgbridge.shaded.okio.Sink;
import tgbridge.shaded.okio.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0002STB'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ9\u0010\u0014\u001a\u00028\u0000\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0018J\r\u0010 \u001a\u00020\u0016\u00a2\u0006\u0004\b \u0010\u0018J\r\u0010!\u001a\u00020\u0016\u00a2\u0006\u0004\b!\u0010\u0018J\r\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u0016\u00a2\u0006\u0004\b%\u0010\u0018J\r\u0010&\u001a\u00020\u0016\u00a2\u0006\u0004\b&\u0010\u0018J\u0015\u0010*\u001a\u00020)2\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010,\u001a\u00020\u0010\u00a2\u0006\u0004\b.\u0010/J\u0015\u00100\u001a\u00020\u00162\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b0\u00101J\r\u00102\u001a\u00020\u0016\u00a2\u0006\u0004\b2\u0010\u0018J\u0017\u00103\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b3\u00104J\r\u00106\u001a\u000205\u00a2\u0006\u0004\b6\u00107J\r\u00108\u001a\u00020\u0016\u00a2\u0006\u0004\b8\u0010\u0018J\u0015\u00109\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b9\u0010:R\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010;\u001a\u0004\b<\u0010=R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010>R\u001a\u0010@\u001a\u00020?8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b@\u0010A\u001a\u0004\bB\u0010CR\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010D\u001a\u0004\bE\u0010FR\u001a\u0010\u0007\u001a\u00020\u00068\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010G\u001a\u0004\bH\u0010IR$\u0010K\u001a\u00020\u00102\u0006\u0010J\u001a\u00020\u00108\u0000@BX\u0080\u000e\u00a2\u0006\f\n\u0004\bK\u0010L\u001a\u0004\bM\u0010NR\u0014\u0010P\u001a\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010NR$\u0010Q\u001a\u00020\u00102\u0006\u0010J\u001a\u00020\u00108\u0000@BX\u0080\u000e\u00a2\u0006\f\n\u0004\bQ\u0010L\u001a\u0004\bR\u0010N\u00a8\u0006U"}, d2={"Ltgbridge/shaded/okhttp3/internal/connection/Exchange;", "", "Ltgbridge/shaded/okhttp3/internal/connection/RealCall;", "call", "Ltgbridge/shaded/okhttp3/EventListener;", "eventListener", "Ltgbridge/shaded/okhttp3/internal/connection/ExchangeFinder;", "finder", "Ltgbridge/shaded/okhttp3/internal/http/ExchangeCodec;", "codec", "<init>", "(Lokhttp3/internal/connection/RealCall;Lokhttp3/EventListener;Lokhttp3/internal/connection/ExchangeFinder;Lokhttp3/internal/http/ExchangeCodec;)V", "Ljava/io/IOException;", "E", "", "bytesRead", "", "responseDone", "requestDone", "e", "bodyComplete", "(JZZLjava/io/IOException;)Ljava/io/IOException;", "", "cancel", "()V", "Ltgbridge/shaded/okhttp3/Request;", "request", "duplex", "Ltgbridge/shaded/okio/Sink;", "createRequestBody", "(Ltgbridge/shaded/okhttp3/Request;Z)Ltgbridge/shaded/okio/Sink;", "detachWithViolence", "finishRequest", "flushRequest", "Ltgbridge/shaded/okhttp3/internal/ws/RealWebSocket$Streams;", "newWebSocketStreams", "()Ltgbridge/shaded/okhttp3/internal/ws/RealWebSocket$Streams;", "noNewExchangesOnConnection", "noRequestBody", "Ltgbridge/shaded/okhttp3/Response;", "response", "Ltgbridge/shaded/okhttp3/ResponseBody;", "openResponseBody", "(Ltgbridge/shaded/okhttp3/Response;)Ltgbridge/shaded/okhttp3/ResponseBody;", "expectContinue", "Ltgbridge/shaded/okhttp3/Response$Builder;", "readResponseHeaders", "(Z)Ltgbridge/shaded/okhttp3/Response$Builder;", "responseHeadersEnd", "(Ltgbridge/shaded/okhttp3/Response;)V", "responseHeadersStart", "trackFailure", "(Ljava/io/IOException;)V", "Ltgbridge/shaded/okhttp3/Headers;", "trailers", "()Ltgbridge/shaded/okhttp3/Headers;", "webSocketUpgradeFailed", "writeRequestHeaders", "(Ltgbridge/shaded/okhttp3/Request;)V", "Ltgbridge/shaded/okhttp3/internal/connection/RealCall;", "getCall$okhttp", "()Lokhttp3/internal/connection/RealCall;", "Ltgbridge/shaded/okhttp3/internal/http/ExchangeCodec;", "Ltgbridge/shaded/okhttp3/internal/connection/RealConnection;", "connection", "Ltgbridge/shaded/okhttp3/internal/connection/RealConnection;", "getConnection$okhttp", "()Lokhttp3/internal/connection/RealConnection;", "Ltgbridge/shaded/okhttp3/EventListener;", "getEventListener$okhttp", "()Lokhttp3/EventListener;", "Ltgbridge/shaded/okhttp3/internal/connection/ExchangeFinder;", "getFinder$okhttp", "()Lokhttp3/internal/connection/ExchangeFinder;", "<set-?>", "hasFailure", "Z", "getHasFailure$okhttp", "()Z", "isCoalescedConnection$okhttp", "isCoalescedConnection", "isDuplex", "isDuplex$okhttp", "RequestBodySink", "ResponseBodySource", "okhttp"})
public final class Exchange {
    @NotNull
    private final RealCall call;
    @NotNull
    private final EventListener eventListener;
    @NotNull
    private final ExchangeFinder finder;
    @NotNull
    private final ExchangeCodec codec;
    private boolean isDuplex;
    private boolean hasFailure;
    @NotNull
    private final RealConnection connection;

    public Exchange(@NotNull RealCall call2, @NotNull EventListener eventListener, @NotNull ExchangeFinder finder, @NotNull ExchangeCodec codec) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.call = call2;
        this.eventListener = eventListener;
        this.finder = finder;
        this.codec = codec;
        this.connection = this.codec.getConnection();
    }

    @NotNull
    public final RealCall getCall$okhttp() {
        return this.call;
    }

    @NotNull
    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    @NotNull
    public final ExchangeFinder getFinder$okhttp() {
        return this.finder;
    }

    public final boolean isDuplex$okhttp() {
        return this.isDuplex;
    }

    public final boolean getHasFailure$okhttp() {
        return this.hasFailure;
    }

    @NotNull
    public final RealConnection getConnection$okhttp() {
        return this.connection;
    }

    public final boolean isCoalescedConnection$okhttp() {
        return !Intrinsics.areEqual((Object)this.finder.getAddress$okhttp().url().host(), (Object)this.connection.route().address().url().host());
    }

    public final void writeRequestHeaders(@NotNull Request request) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            this.eventListener.requestHeadersStart(this.call);
            this.codec.writeRequestHeaders(request);
            this.eventListener.requestHeadersEnd(this.call, request);
        }
        catch (IOException e) {
            this.eventListener.requestFailed(this.call, e);
            this.trackFailure(e);
            throw e;
        }
    }

    @NotNull
    public final Sink createRequestBody(@NotNull Request request, boolean duplex) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.isDuplex = duplex;
        RequestBody requestBody = request.body();
        Intrinsics.checkNotNull((Object)requestBody);
        long contentLength = requestBody.contentLength();
        this.eventListener.requestBodyStart(this.call);
        Sink rawRequestBody = this.codec.createRequestBody(request, contentLength);
        return new RequestBodySink(rawRequestBody, contentLength);
    }

    public final void flushRequest() throws IOException {
        try {
            this.codec.flushRequest();
        }
        catch (IOException e) {
            this.eventListener.requestFailed(this.call, e);
            this.trackFailure(e);
            throw e;
        }
    }

    public final void finishRequest() throws IOException {
        try {
            this.codec.finishRequest();
        }
        catch (IOException e) {
            this.eventListener.requestFailed(this.call, e);
            this.trackFailure(e);
            throw e;
        }
    }

    public final void responseHeadersStart() {
        this.eventListener.responseHeadersStart(this.call);
    }

    @Nullable
    public final Response.Builder readResponseHeaders(boolean expectContinue) throws IOException {
        try {
            Response.Builder result;
            Response.Builder builder = result = this.codec.readResponseHeaders(expectContinue);
            if (builder != null) {
                builder.initExchange$okhttp(this);
            }
            return result;
        }
        catch (IOException e) {
            this.eventListener.responseFailed(this.call, e);
            this.trackFailure(e);
            throw e;
        }
    }

    public final void responseHeadersEnd(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.eventListener.responseHeadersEnd(this.call, response);
    }

    @NotNull
    public final ResponseBody openResponseBody(@NotNull Response response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            String contentType = Response.header$default(response, "Content-Type", null, 2, null);
            long contentLength = this.codec.reportedContentLength(response);
            Source rawSource = this.codec.openResponseBodySource(response);
            ResponseBodySource source2 = new ResponseBodySource(rawSource, contentLength);
            return new RealResponseBody(contentType, contentLength, Okio.buffer(source2));
        }
        catch (IOException e) {
            this.eventListener.responseFailed(this.call, e);
            this.trackFailure(e);
            throw e;
        }
    }

    @NotNull
    public final Headers trailers() throws IOException {
        return this.codec.trailers();
    }

    @NotNull
    public final RealWebSocket.Streams newWebSocketStreams() throws SocketException {
        this.call.timeoutEarlyExit();
        return this.codec.getConnection().newWebSocketStreams$okhttp(this);
    }

    public final void webSocketUpgradeFailed() {
        this.bodyComplete(-1L, true, true, null);
    }

    public final void noNewExchangesOnConnection() {
        this.codec.getConnection().noNewExchanges$okhttp();
    }

    public final void cancel() {
        this.codec.cancel();
    }

    public final void detachWithViolence() {
        this.codec.cancel();
        this.call.messageDone$okhttp(this, true, true, null);
    }

    private final void trackFailure(IOException e) {
        this.hasFailure = true;
        this.finder.trackFailure(e);
        this.codec.getConnection().trackFailure$okhttp(this.call, e);
    }

    public final <E extends IOException> E bodyComplete(long bytesRead, boolean responseDone, boolean requestDone, E e) {
        if (e != null) {
            this.trackFailure(e);
        }
        if (requestDone) {
            if (e != null) {
                this.eventListener.requestFailed(this.call, e);
            } else {
                this.eventListener.requestBodyEnd(this.call, bytesRead);
            }
        }
        if (responseDone) {
            if (e != null) {
                this.eventListener.responseFailed(this.call, e);
            } else {
                this.eventListener.responseBodyEnd(this.call, bytesRead);
            }
        }
        return this.call.messageDone$okhttp(this, requestDone, responseDone, e);
    }

    public final void noRequestBody() {
        this.call.messageDone$okhttp(this, true, false, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\u000e\u001a\u00028\u0000\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\nJ\u001f\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0017\u00a8\u0006\u001c"}, d2={"Ltgbridge/shaded/okhttp3/internal/connection/Exchange$RequestBodySink;", "Ltgbridge/shaded/okio/ForwardingSink;", "Ltgbridge/shaded/okio/Sink;", "delegate", "", "contentLength", "<init>", "(Lokhttp3/internal/connection/Exchange;Lokio/Sink;J)V", "", "close", "()V", "Ljava/io/IOException;", "E", "e", "complete", "(Ljava/io/IOException;)Ljava/io/IOException;", "flush", "Ltgbridge/shaded/okio/Buffer;", "source", "byteCount", "write", "(Ltgbridge/shaded/okio/Buffer;J)V", "bytesReceived", "J", "", "closed", "Z", "completed", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nExchange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Exchange.kt\nokhttp3/internal/connection/Exchange$RequestBodySink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
    private final class RequestBodySink
    extends ForwardingSink {
        private final long contentLength;
        private boolean completed;
        private long bytesReceived;
        private boolean closed;

        public RequestBodySink(Sink delegate, long contentLength) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(delegate);
            this.contentLength = contentLength;
        }

        @Override
        public void write(@NotNull Buffer source2, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.contentLength != -1L && this.bytesReceived + byteCount > this.contentLength) {
                throw new ProtocolException("expected " + this.contentLength + " bytes but received " + (this.bytesReceived + byteCount));
            }
            try {
                super.write(source2, byteCount);
                this.bytesReceived += byteCount;
            }
            catch (IOException e) {
                throw this.complete(e);
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                super.flush();
            }
            catch (IOException e) {
                throw this.complete(e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.contentLength != -1L && this.bytesReceived != this.contentLength) {
                throw new ProtocolException("unexpected end of stream");
            }
            try {
                super.close();
                this.complete(null);
            }
            catch (IOException e) {
                throw this.complete(e);
            }
        }

        private final <E extends IOException> E complete(E e) {
            if (this.completed) {
                return e;
            }
            this.completed = true;
            return Exchange.this.bodyComplete(this.bytesReceived, false, true, e);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000e\u001a\u00028\u0000\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R\u0016\u0010\u001b\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0019\u00a8\u0006\u001c"}, d2={"Ltgbridge/shaded/okhttp3/internal/connection/Exchange$ResponseBodySource;", "Ltgbridge/shaded/okio/ForwardingSource;", "Ltgbridge/shaded/okio/Source;", "delegate", "", "contentLength", "<init>", "(Lokhttp3/internal/connection/Exchange;Lokio/Source;J)V", "", "close", "()V", "Ljava/io/IOException;", "E", "e", "complete", "(Ljava/io/IOException;)Ljava/io/IOException;", "Ltgbridge/shaded/okio/Buffer;", "sink", "byteCount", "read", "(Ltgbridge/shaded/okio/Buffer;J)J", "bytesReceived", "J", "", "closed", "Z", "completed", "invokeStartEvent", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nExchange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Exchange.kt\nokhttp3/internal/connection/Exchange$ResponseBodySource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
    public final class ResponseBodySource
    extends ForwardingSource {
        private final long contentLength;
        private long bytesReceived;
        private boolean invokeStartEvent;
        private boolean completed;
        private boolean closed;

        public ResponseBodySource(Source delegate, long contentLength) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(delegate);
            this.contentLength = contentLength;
            this.invokeStartEvent = true;
            if (this.contentLength == 0L) {
                this.complete(null);
            }
        }

        @Override
        public long read(@NotNull Buffer sink2, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            try {
                long read = this.delegate().read(sink2, byteCount);
                if (this.invokeStartEvent) {
                    this.invokeStartEvent = false;
                    Exchange.this.getEventListener$okhttp().responseBodyStart(Exchange.this.getCall$okhttp());
                }
                if (read == -1L) {
                    this.complete(null);
                    return -1L;
                }
                long newBytesReceived = this.bytesReceived + read;
                if (this.contentLength != -1L && newBytesReceived > this.contentLength) {
                    throw new ProtocolException("expected " + this.contentLength + " bytes but received " + newBytesReceived);
                }
                this.bytesReceived = newBytesReceived;
                if (newBytesReceived == this.contentLength) {
                    this.complete(null);
                }
                return read;
            }
            catch (IOException e) {
                throw this.complete(e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
                this.complete(null);
            }
            catch (IOException e) {
                throw this.complete(e);
            }
        }

        public final <E extends IOException> E complete(E e) {
            if (this.completed) {
                return e;
            }
            this.completed = true;
            if (e == null && this.invokeStartEvent) {
                this.invokeStartEvent = false;
                Exchange.this.getEventListener$okhttp().responseBodyStart(Exchange.this.getCall$okhttp());
            }
            return Exchange.this.bodyComplete(this.bytesReceived, true, false, e);
        }
    }
}

