/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.snakeyaml.engine.kmp.exceptions;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tgbridge.shaded.snakeyaml.engine.kmp.exceptions.YamlEngineException;
import tgbridge.shaded.snakeyaml.engine.kmp.internal.utils.Character;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\f\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000e\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0012"}, d2={"Ltgbridge/shaded/snakeyaml/engine/kmp/exceptions/ReaderException;", "Ltgbridge/shaded/snakeyaml/engine/kmp/exceptions/YamlEngineException;", "", "name", "", "position", "codePoint", "message", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getName", "I", "getPosition", "()I", "getCodePoint", "snakeyaml-engine-kmp"})
public final class ReaderException
extends YamlEngineException {
    @NotNull
    private final String name;
    private final int position;
    private final int codePoint;

    public ReaderException(@NotNull String name, int position, int codePoint, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message);
        this.name = name;
        this.position = position;
        this.codePoint = codePoint;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getPosition() {
        return this.position;
    }

    public final int getCodePoint() {
        return this.codePoint;
    }

    @Override
    @NotNull
    public String toString() {
        String s = StringsKt.concatToString((char[])Character.INSTANCE.toChars$snakeyaml_engine_kmp(this.codePoint));
        String string = Integer.toString(this.codePoint, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String charHex = string2;
        return StringsKt.trimIndent((String)("\n             unacceptable code point '" + s + "' (0x" + charHex + ") " + this.getMessage() + "\n             in \"" + this.name + "\", position " + this.position + "\n             "));
    }
}

