/*
 * Decompiled with CFR 0.152.
 */
package dev.vanutp.tgbridge.common;

import com.google.gson.Gson;
import dev.vanutp.tgbridge.common.ILogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import tgbridge.shaded.kotlin.Metadata;
import tgbridge.shaded.kotlin.Unit;
import tgbridge.shaded.kotlin.collections.CollectionsKt;
import tgbridge.shaded.kotlin.io.CloseableKt;
import tgbridge.shaded.kotlin.jvm.internal.Intrinsics;
import tgbridge.shaded.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\bJ\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000fJ\b\u0010\u0019\u001a\u00020\u0017H\u0002J\u0006\u0010\u001a\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\u0006\u001aB\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n \t* \u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/vanutp/tgbridge/common/MuteService;", "", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "mutedUsers", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Ljava/util/UUID;", "tgbridge.shaded.kotlin.jvm.PlatformType", "", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "executor", "Ljava/util/concurrent/ExecutorService;", "filePath", "Ljava/nio/file/Path;", "logger", "Ldev/vanutp/tgbridge/common/ILogger;", "mute", "uuid", "unmute", "isMuted", "init", "", "configPath", "saveAsync", "shutdown", "tgbridge-common"})
public final class MuteService {
    @NotNull
    public static final MuteService INSTANCE = new MuteService();
    @NotNull
    private static final Gson gson = new Gson();
    private static final ConcurrentHashMap.KeySetView<UUID, Boolean> mutedUsers = ConcurrentHashMap.newKeySet();
    @NotNull
    private static final ExecutorService executor;
    private static Path filePath;
    private static ILogger logger;

    private MuteService() {
    }

    public final boolean mute(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        if (mutedUsers.add(uuid)) {
            this.saveAsync();
            return true;
        }
        return false;
    }

    public final boolean unmute(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        if (mutedUsers.remove(uuid)) {
            this.saveAsync();
            return true;
        }
        return false;
    }

    public final boolean isMuted(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return mutedUsers.contains(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(@NotNull ILogger logger, @NotNull Path configPath) {
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(configPath, "configPath");
        MuteService.logger = logger;
        filePath = configPath.resolve("muted_users.json");
        Path path = filePath;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException("filePath");
            path = null;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Path path2 = filePath;
            if (path2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("filePath");
                path2 = null;
            }
            Closeable closeable = Files.newBufferedReader(path2);
            Throwable throwable = null;
            try {
                UUID[] uUIDArray;
                BufferedReader reader = (BufferedReader)closeable;
                boolean bl = false;
                if ((UUID[])gson.fromJson((Reader)reader, UUID[].class) == null) {
                    return;
                }
                UUID[] loaded = uUIDArray;
                mutedUsers.clear();
                ConcurrentHashMap.KeySetView<UUID, Boolean> keySetView = mutedUsers;
                Intrinsics.checkNotNullExpressionValue(keySetView, "mutedUsers");
                boolean bl2 = CollectionsKt.addAll((Collection)keySetView, loaded);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            logger.error("Failed to load muted users: " + e.getMessage(), e);
        }
    }

    private final void saveAsync() {
        ConcurrentHashMap.KeySetView<UUID, Boolean> keySetView = mutedUsers;
        Intrinsics.checkNotNullExpressionValue(keySetView, "mutedUsers");
        Set snapshot = CollectionsKt.toSet((Iterable)keySetView);
        executor.submit(() -> MuteService.saveAsync$lambda$2(snapshot));
    }

    public final void shutdown() {
        executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void saveAsync$lambda$2(Set $snapshot) {
        try {
            Path path = filePath;
            if (path == null) {
                Intrinsics.throwUninitializedPropertyAccessException("filePath");
                path = null;
            }
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Path path2 = filePath;
            if (path2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("filePath");
                path2 = null;
            }
            Closeable closeable = Files.newBufferedWriter(path2, new OpenOption[0]);
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl = false;
                gson.toJson((Object)$snapshot, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            ILogger iLogger = logger;
            if (iLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException("logger");
                iLogger = null;
            }
            iLogger.error("Failed to save muted users: " + e.getMessage(), e);
        }
    }

    static {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue(executorService, "newSingleThreadExecutor(...)");
        executor = executorService;
    }
}

