/*
 * Decompiled with CFR 0.152.
 */
package dev.vanutp.tgbridge.common.compat;

import dev.vanutp.tgbridge.common.compat.OggPage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import tgbridge.shaded.kotlin.Metadata;
import tgbridge.shaded.kotlin.Pair;
import tgbridge.shaded.kotlin.collections.ArraysKt;
import tgbridge.shaded.kotlin.collections.CollectionsKt;
import tgbridge.shaded.kotlin.jvm.internal.Intrinsics;
import tgbridge.shaded.kotlin.jvm.internal.SourceDebugExtension;
import tgbridge.shaded.kotlin.random.Random;
import tgbridge.shaded.kotlin.text.Charsets;
import tgbridge.shaded.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\u001a\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\f\u001a\u00020\b\u001a\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u001a\b\u0010\u0012\u001a\u00020\u000bH\u0002\u001a\b\u0010\u0013\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"SAMPLES_PER_PACKET", "", "CRC_TABLE", "", "calculateCrc", "", "data", "", "", "parseOggPage", "Ltgbridge/shaded/kotlin/Pair;", "Ldev/vanutp/tgbridge/common/compat/OggPage;", "bytes", "start", "extractOpusPackets", "", "serializeOggPage", "page", "createOpusHeadPage", "createOpusTagsPage", "createOggPage", "packets", "offset", "createOgg", "tgbridge-common"})
@SourceDebugExtension(value={"SMAP\nOggUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OggUtils.kt\ndev/vanutp/tgbridge/common/compat/OggUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,260:1\n1797#2,2:261\n1799#2:266\n827#2:267\n855#2,2:268\n1557#2:270\n1628#2,3:271\n2669#2,7:274\n1863#2,2:281\n1368#2:283\n1454#2,5:284\n12834#3,3:263\n11205#3:289\n11540#3,3:290\n*S KotlinDebug\n*F\n+ 1 OggUtils.kt\ndev/vanutp/tgbridge/common/compat/OggUtilsKt\n*L\n45#1:261,2\n45#1:266\n143#1:267\n143#1:268,2\n171#1:270\n171#1:271,3\n178#1:274,7\n254#1:281,2\n258#1:283\n258#1:284,5\n46#1:263,3\n42#1:289\n42#1:290,3\n*E\n"})
public final class OggUtilsKt {
    private static final long SAMPLES_PER_PACKET = 960L;
    @NotNull
    private static final int[] CRC_TABLE;

    /*
     * WARNING - void declaration
     */
    private static final int calculateCrc(Iterable<byte[]> data) {
        void $this$fold$iv;
        Iterable<byte[]> iterable = data;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void $this$fold$iv2;
            void array;
            byte[] byArray = (byte[])element$iv;
            int crc = accumulator$iv;
            boolean bl = false;
            void var10_10 = array;
            int initial$iv2 = crc;
            boolean $i$f$fold2 = false;
            int accumulator$iv2 = initial$iv2;
            int n = ((void)$this$fold$iv2).length;
            for (int i = 0; i < n; ++i) {
                void byteVal;
                void element$iv2;
                void var17_17 = element$iv2 = $this$fold$iv2[i];
                int crc2 = accumulator$iv2;
                boolean bl2 = false;
                accumulator$iv2 = crc2 << 8 ^ CRC_TABLE[crc2 >>> 24 ^ byteVal & 0xFF];
            }
            accumulator$iv = accumulator$iv2;
        }
        return accumulator$iv;
    }

    private static final Pair<OggPage, Integer> parseOggPage(byte[] bytes, int start) {
        int offset = start;
        byte[] byArray = bytes;
        int n = offset + 27;
        byte[] headerBytes = ArraysKt.copyOfRange(byArray, offset, n);
        ByteBuffer header = ByteBuffer.wrap(headerBytes).order(ByteOrder.LITTLE_ENDIAN);
        offset += 27;
        if (header.get(0) != 79 || header.get(1) != 103 || header.get(2) != 103 || header.get(3) != 83) {
            throw new IllegalArgumentException("Invalid capture pattern");
        }
        header.position(4);
        if (header.get() != 0) {
            throw new IllegalArgumentException("Invalid version");
        }
        byte headerTypeFlag = header.get();
        boolean continuedPacket = (headerTypeFlag & 1) != 0;
        boolean beginningOfStream = (headerTypeFlag & 2) != 0;
        boolean endOfStream = (headerTypeFlag & 4) != 0;
        long granulePosition = header.getLong();
        int streamSerialNumber = header.getInt();
        int pageSequenceNumber = header.getInt();
        int pageChecksum = header.getInt();
        int segmentTableSize = header.get() & 0xFF;
        byte[] byArray2 = bytes;
        int n2 = offset + segmentTableSize;
        byte[] segmentTable = ArraysKt.copyOfRange(byArray2, offset, n2);
        offset += segmentTableSize;
        List segmentLengths = new ArrayList();
        int i = 0;
        while (i < segmentTable.length) {
            int segmentLength = 0;
            while (i < segmentTable.length) {
                int n3 = segmentTable[i] & 0xFF;
                segmentLength += n3;
                ++i;
                if (n3 >= 255) continue;
            }
            segmentLengths.add(segmentLength);
        }
        List packets = new ArrayList();
        Iterator n3 = segmentLengths.iterator();
        while (n3.hasNext()) {
            int length = ((Number)n3.next()).intValue();
            byte[] byArray3 = bytes;
            int n4 = offset + length;
            byte[] packetData = ArraysKt.copyOfRange(byArray3, offset, n4);
            offset += length;
            packets.add(packetData);
        }
        ArraysKt.fill(headerBytes, (byte)0, 22, 26);
        byte[][] byArrayArray = new byte[][]{headerBytes, segmentTable};
        int calculatedChecksum = OggUtilsKt.calculateCrc(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])byArrayArray), (Iterable)packets));
        if (calculatedChecksum != pageChecksum) {
            throw new IllegalArgumentException("Invalid checksum: expected " + pageChecksum + ", got " + calculatedChecksum);
        }
        return new Pair<OggPage, Integer>(new OggPage(continuedPacket, beginningOfStream, endOfStream, granulePosition, streamSerialNumber, pageSequenceNumber, packets), offset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<byte[]> extractOpusPackets(@NotNull byte[] bytes) {
        void $this$filterNotTo$iv$iv;
        Object page;
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        List packets = new ArrayList();
        int offset = 0;
        while (offset < bytes.length) {
            int newOffset;
            Pair<OggPage, Integer> pair = OggUtilsKt.parseOggPage(bytes, offset);
            page = pair.component1();
            offset = newOffset = ((Number)pair.component2()).intValue();
            List newPackets = CollectionsKt.toMutableList((Collection)((OggPage)page).getPackets());
            if (((OggPage)page).getContinuedPacket()) {
                packets.set(packets.size() - 1, ArraysKt.plus((byte[])CollectionsKt.last(packets), (byte[])newPackets.remove(0)));
            }
            packets.addAll(newPackets);
        }
        page = "OpusHead";
        byte[] byArray = ((String)page).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        List<Byte> opusHead = ArraysKt.toList(byArray);
        String newOffset = "OpusTags";
        byte[] byArray2 = newOffset.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray2, "getBytes(...)");
        List<Byte> opusTags = ArraysKt.toList(byArray2);
        Iterable $this$filterNot$iv = packets;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            byte[] it = (byte[])element$iv$iv;
            boolean bl = false;
            List<Byte> packetHeader = ArraysKt.take(it, 8);
            if (Intrinsics.areEqual(packetHeader, opusHead) || Intrinsics.areEqual(packetHeader, opusTags)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] serializeOggPage(OggPage page) {
        void $this$reduce$iv;
        Object object;
        void $this$mapTo$iv$iv;
        if (page.getPackets().size() > 255) {
            throw new IllegalArgumentException("Too many packets in an ogg page");
        }
        String string = "OggS";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] capturePattern = byArray;
        int headerTypeFlag = 0;
        if (page.getContinuedPacket()) {
            headerTypeFlag |= 1;
        }
        if (page.getBeginningOfStream()) {
            headerTypeFlag |= 2;
        }
        if (page.getEndOfStream()) {
            headerTypeFlag |= 4;
        }
        byte[] header = ByteBuffer.allocate(27).order(ByteOrder.LITTLE_ENDIAN).put(capturePattern).put((byte)0).put((byte)headerTypeFlag).putLong(page.getGranulePosition()).putInt(page.getStreamSerialNumber()).putInt(page.getPageSequenceNumber()).putInt(0).put((byte)page.getPackets().size()).array();
        Iterable $this$map$iv = page.getPackets();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void packet;
            byte[] byArray2 = (byte[])item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            if (((void)packet).length > 255) {
                throw new IllegalArgumentException("Packet size exceeds 255 bytes");
            }
            object.add((byte)((void)packet).length);
        }
        byte[] segmentTable = CollectionsKt.toByteArray((List)destination$iv$iv);
        Intrinsics.checkNotNull(header);
        Iterable $i$f$map22 = page.getPackets();
        object = ArraysKt.plus(header, segmentTable);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void packet;
            Object object2 = (byte[])iterator$iv.next();
            byte[] acc = (byte[])accumulator$iv;
            boolean bl = false;
            accumulator$iv = ArraysKt.plus(acc, (byte[])packet);
        }
        byte[] data = ArraysKt.plus((byte[])object, (byte[])accumulator$iv);
        int crc = OggUtilsKt.calculateCrc((Iterable<byte[]>)CollectionsKt.listOf(data));
        ByteBuffer.wrap(data, 22, 4).order(ByteOrder.LITTLE_ENDIAN).putInt(crc);
        return data;
    }

    private static final OggPage createOpusHeadPage() {
        String string = "OpusHead";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] opusHead = byArray;
        byte[] data = ByteBuffer.allocate(19).order(ByteOrder.LITTLE_ENDIAN).put(opusHead).put((byte)1).put((byte)1).putShort((short)312).putInt(48000).putShort((short)0).put((byte)0).array();
        return new OggPage(false, true, false, 0L, 0, 0, CollectionsKt.listOf(data), 48, null);
    }

    private static final OggPage createOpusTagsPage() {
        String string = "OpusTags";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] opusTags = byArray;
        String string2 = "tgbridge";
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray2, "getBytes(...)");
        byte[] vendorString = byArray2;
        String string3 = "fox=\ud83e\udd8a";
        byte[] byArray3 = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray3, "getBytes(...)");
        byte[] tag = byArray3;
        byte[] data = ByteBuffer.allocate(opusTags.length + 4 + vendorString.length + 4 + 4 + tag.length).order(ByteOrder.LITTLE_ENDIAN).put(opusTags).putInt(vendorString.length).put(vendorString).putInt(1).putInt(tag.length).put(tag).array();
        return new OggPage(false, false, false, 0L, 0, 0, CollectionsKt.listOf(data), 48, null);
    }

    private static final OggPage createOggPage(List<byte[]> packets, int offset) {
        List<byte[]> packetData = packets.subList(offset, Math.min(offset + 255, packets.size()));
        long granulePosition = (long)(offset + packetData.size()) * 960L;
        return new OggPage(offset > 0, false, offset + packetData.size() >= packets.size(), granulePosition, 0, 0, packetData, 48, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] createOgg(@NotNull List<byte[]> packets) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(packets, "packets");
        OggPage[] oggPageArray = new OggPage[]{OggUtilsKt.createOpusHeadPage(), OggUtilsKt.createOpusTagsPage()};
        List<OggPage> pages = CollectionsKt.mutableListOf(oggPageArray);
        for (int offset = 0; offset < packets.size(); offset += 255) {
            pages.add(OggUtilsKt.createOggPage(packets, offset));
        }
        int streamSerialNumber = Random.Default.nextInt();
        int pageSequenceNumber = 0;
        Iterable $this$forEach$iv = pages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OggPage page = (OggPage)element$iv;
            boolean bl = false;
            page.setStreamSerialNumber(streamSerialNumber);
            int n = pageSequenceNumber;
            pageSequenceNumber = n + 1;
            page.setPageSequenceNumber(n);
        }
        Iterable $this$flatMap$iv = pages;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            OggPage it = (OggPage)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList(OggUtilsKt.serializeOggPage(it));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.toByteArray((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        long[] lArray = new long[]{0L, 79764919L, 159529838L, 222504665L, 319059676L, 398814059L, 445009330L, 507990021L, 638119352L, 583659535L, 797628118L, 726387553L, 890018660L, 835552979L, 1015980042L, 944750013L, 1276238704L, 1221641927L, 1167319070L, 1095957929L, 1595256236L, 1540665371L, 1452775106L, 1381403509L, 1780037320L, 1859660671L, 1671105958L, 1733955601L, 2031960084L, 2111593891L, 1889500026L, 1952343757L, 2552477408L, 2632100695L, 2443283854L, 2506133561L, 2334638140L, 2414271883L, 2191915858L, 2254759653L, 3190512472L, 3135915759L, 3081330742L, 3009969537L, 2905550212L, 2850959411L, 2762807018L, 2691435357L, 3560074640L, 3505614887L, 3719321342L, 3648080713L, 3342211916L, 3287746299L, 3467911202L, 3396681109L, 4063920168L, 4143685023L, 4223187782L, 4286162673L, 3779000052L, 3858754371L, 3904687514L, 3967668269L, 881225847L, 809987520L, 1023691545L, 969234094L, 662832811L, 591600412L, 771767749L, 717299826L, 311336399L, 374308984L, 453813921L, 533576470L, 25881363L, 88864420L, 134795389L, 214552010L, 2023205639L, 2086057648L, 1897238633L, 1976864222L, 1804852699L, 1867694188L, 1645340341L, 1724971778L, 1587496639L, 1516133128L, 1461550545L, 1406951526L, 1302016099L, 1230646740L, 1142491917L, 1087903418L, 2896545431L, 2825181984L, 2770861561L, 2716262478L, 3215044683L, 3143675388L, 3055782693L, 3001194130L, 2326604591L, 2389456536L, 2200899649L, 2280525302L, 2578013683L, 2640855108L, 2418763421L, 2498394922L, 3769900519L, 3832873040L, 3912640137L, 3992402750L, 4088425275L, 4151408268L, 4197601365L, 4277358050L, 3334271071L, 3263032808L, 3476998961L, 3422541446L, 3585640067L, 3514407732L, 3694837229L, 3640369242L, 1762451694L, 1842216281L, 1619975040L, 1682949687L, 2047383090L, 2127137669L, 1938468188L, 2001449195L, 1325665622L, 1271206113L, 1183200824L, 1111960463L, 1543535498L, 1489069629L, 1434599652L, 1363369299L, 622672798L, 568075817L, 748617968L, 677256519L, 907627842L, 853037301L, 1067152940L, 995781531L, 51762726L, 131386257L, 177728840L, 240578815L, 269590778L, 349224269L, 429104020L, 491947555L, 4046411278L, 4126034873L, 4172115296L, 4234965207L, 3794477266L, 3874110821L, 3953728444L, 4016571915L, 3609705398L, 3555108353L, 3735388376L, 3664026991L, 3290680682L, 3236090077L, 3449943556L, 3378572211L, 3174993278L, 3120533705L, 3032266256L, 2961025959L, 2923101090L, 2868635157L, 2813903052L, 2742672763L, 2604032198L, 2683796849L, 2461293480L, 2524268063L, 2284983834L, 2364738477L, 2175806836L, 2238787779L, 1569362073L, 1498123566L, 1409854455L, 1355396672L, 1317987909L, 1246755826L, 1192025387L, 1137557660L, 2072149281L, 2135122070L, 1912620623L, 1992383480L, 1753615357L, 1816598090L, 1627664531L, 1707420964L, 295390185L, 358241886L, 404320391L, 483945776L, 43990325L, 106832002L, 186451547L, 266083308L, 932423249L, 861060070L, 1041341759L, 986742920L, 613929101L, 542559546L, 756411363L, 701822548L, 3316196985L, 3244833742L, 3425377559L, 3370778784L, 3601682597L, 3530312978L, 3744426955L, 3689838204L, 3819031489L, 3881883254L, 3928223919L, 4007849240L, 4037393693L, 4100235434L, 4180117107L, 4259748804L, 2310601993L, 2373574846L, 2151335527L, 2231098320L, 2596047829L, 2659030626L, 2470359227L, 2550115596L, 2947551409L, 2876312838L, 2788305887L, 2733848168L, 3165939309L, 3094707162L, 3040238851L, 2985771188L};
        long[] $this$map$iv = lArray;
        boolean $i$f$map = false;
        long[] lArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_8 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((int)it);
        }
        CRC_TABLE = CollectionsKt.toIntArray((List)var3_3);
    }
}

