/*
 * Decompiled with CFR 0.152.
 */
package dev.vanutp.tgbridge.paper;

import dev.vanutp.tgbridge.common.models.TgbridgeAdvancementEvent;
import dev.vanutp.tgbridge.common.models.TgbridgeDeathEvent;
import dev.vanutp.tgbridge.common.models.TgbridgeJoinEvent;
import dev.vanutp.tgbridge.common.models.TgbridgeLeaveEvent;
import dev.vanutp.tgbridge.common.models.TgbridgeMcChatMessageEvent;
import dev.vanutp.tgbridge.common.models.TgbridgePlayer;
import dev.vanutp.tgbridge.paper.PaperBootstrap;
import dev.vanutp.tgbridge.paper.PaperTelegramBridge;
import dev.vanutp.tgbridge.paper.UtilsKt;
import io.papermc.paper.advancement.AdvancementDisplay;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import tgbridge.shaded.kotlin.Metadata;
import tgbridge.shaded.kotlin.collections.ArraysKt;
import tgbridge.shaded.kotlin.jvm.internal.Intrinsics;
import tgbridge.shaded.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/vanutp/tgbridge/paper/EventManager;", "Lorg/bukkit/event/Listener;", "plugin", "Ldev/vanutp/tgbridge/paper/PaperBootstrap;", "<init>", "(Ldev/vanutp/tgbridge/paper/PaperBootstrap;)V", "register", "", "onServerLoad", "e", "Lorg/bukkit/event/server/ServerLoadEvent;", "registerChatMessageListener", "onPlayerAdvancement", "Lorg/bukkit/event/player/PlayerAdvancementDoneEvent;", "onPlayerDeath", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "registerJoinLeaveListener", "registerCommandHandlers", "tgbridge-paper"})
public final class EventManager
implements Listener {
    @NotNull
    private final PaperBootstrap plugin;

    public EventManager(@NotNull PaperBootstrap plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public final void register() {
        this.registerChatMessageListener();
        this.registerJoinLeaveListener();
        this.registerCommandHandlers();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler
    public final void onServerLoad(@NotNull ServerLoadEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.plugin.getTgbridge().onServerStarted();
    }

    private final void registerChatMessageListener() {
        this.plugin.getServer().getPluginManager().registerEvents(new Listener(this){
            final /* synthetic */ EventManager this$0;
            {
                this.this$0 = $receiver;
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public final void onMessage(AsyncChatEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                if (e.isCancelled()) {
                    return;
                }
                PaperTelegramBridge paperTelegramBridge = EventManager.access$getPlugin$p(this.this$0).getTgbridge();
                Player player = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                TgbridgePlayer tgbridgePlayer = UtilsKt.toTgbridge(player);
                Component component = e.message();
                Intrinsics.checkNotNullExpressionValue(component, "message(...)");
                paperTelegramBridge.onChatMessage(new TgbridgeMcChatMessageEvent(tgbridgePlayer, component, e, null, 8, null));
            }
        }, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerAdvancement(@NotNull PlayerAdvancementDoneEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        AdvancementDisplay display = e.getAdvancement().getDisplay();
        if (display == null || !display.doesAnnounceToChat()) {
            return;
        }
        String string = display.frame().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String type = string;
        PaperTelegramBridge paperTelegramBridge = this.plugin.getTgbridge();
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        TgbridgePlayer tgbridgePlayer = UtilsKt.toTgbridge(player);
        Component component = display.title();
        Intrinsics.checkNotNullExpressionValue(component, "title(...)");
        Component component2 = display.description();
        Intrinsics.checkNotNullExpressionValue(component2, "description(...)");
        paperTelegramBridge.onPlayerAdvancement(new TgbridgeAdvancementEvent(tgbridgePlayer, type, component, component2, e, null, 32, null));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerDeath(@NotNull PlayerDeathEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Component msg = e.deathMessage();
        PaperTelegramBridge paperTelegramBridge = this.plugin.getTgbridge();
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        paperTelegramBridge.onPlayerDeath(new TgbridgeDeathEvent(UtilsKt.toTgbridge(player), msg, e, null, 8, null));
    }

    private final void registerJoinLeaveListener() {
        this.plugin.getServer().getPluginManager().registerEvents(new Listener(this){
            final /* synthetic */ EventManager this$0;
            {
                this.this$0 = $receiver;
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public final void onPlayerJoin(PlayerJoinEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                PaperTelegramBridge paperTelegramBridge = EventManager.access$getPlugin$p(this.this$0).getTgbridge();
                Player player = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                paperTelegramBridge.onPlayerJoin(new TgbridgeJoinEvent(UtilsKt.toTgbridge(player), e.getPlayer().hasPlayedBefore(), e, null, false, 24, null));
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public final void onPlayerQuit(PlayerQuitEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                PaperTelegramBridge paperTelegramBridge = EventManager.access$getPlugin$p(this.this$0).getTgbridge();
                Player player = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                paperTelegramBridge.onPlayerLeave(new TgbridgeLeaveEvent(UtilsKt.toTgbridge(player), e, null, false, 12, null));
            }
        }, (Plugin)this.plugin);
    }

    private final void registerCommandHandlers() {
        PluginCommand pluginCommand = this.plugin.getCommand("tgbridge");
        Intrinsics.checkNotNull(pluginCommand);
        pluginCommand.setExecutor((arg_0, arg_1, arg_2, arg_3) -> EventManager.registerCommandHandlers$lambda$0(this, arg_0, arg_1, arg_2, arg_3));
    }

    private static final boolean registerCommandHandlers$lambda$0(EventManager this$0, CommandSender commandSender, Command command, String string, String[] args2) {
        Intrinsics.checkNotNullParameter(commandSender, "commandSender");
        Intrinsics.checkNotNullParameter(command, "<unused var>");
        Intrinsics.checkNotNullParameter(string, "<unused var>");
        String[] stringArray = args2;
        String[] stringArray2 = new String[]{"reload"};
        if (ArraysKt.contentDeepEquals(stringArray, stringArray2)) {
            if (!commandSender.isOp()) {
                return false;
            }
            return this$0.plugin.getTgbridge().onReloadCommand(UtilsKt.toTgbridge(commandSender));
        }
        stringArray = args2;
        stringArray2 = new String[]{"toggle"};
        if (ArraysKt.contentDeepEquals(stringArray, stringArray2)) {
            return this$0.plugin.getTgbridge().onToggleMuteCommand(UtilsKt.toTgbridge(commandSender));
        }
        return false;
    }

    public static final /* synthetic */ PaperBootstrap access$getPlugin$p(EventManager $this) {
        return $this.plugin;
    }
}

