/*
 * Decompiled with CFR 0.152.
 */
package dev.vanutp.tgbridge.paper;

import dev.vanutp.tgbridge.common.TelegramBridge;
import dev.vanutp.tgbridge.paper.PaperBootstrap;
import dev.vanutp.tgbridge.paper.PaperLogger;
import dev.vanutp.tgbridge.paper.PaperPlatform;
import dev.vanutp.tgbridge.paper.compat.CarbonChatCompat;
import dev.vanutp.tgbridge.paper.compat.ChattyV2Compat;
import dev.vanutp.tgbridge.paper.compat.ChattyV3Compat;
import dev.vanutp.tgbridge.paper.compat.EssentialsVanishCompat;
import dev.vanutp.tgbridge.paper.compat.GenericVanishCompat;
import dev.vanutp.tgbridge.paper.compat.HeroChatCompat;
import dev.vanutp.tgbridge.paper.compat.IncompatibleChatPluginCompat;
import dev.vanutp.tgbridge.paper.compat.SuperVanishCompat;
import dev.vanutp.tgbridge.paper.compat.VoiceMessagesPaperCompat;
import java.nio.file.Files;
import java.nio.file.Path;
import tgbridge.shaded.kotlin.Metadata;
import tgbridge.shaded.kotlin.jvm.internal.Intrinsics;
import tgbridge.shaded.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldev/vanutp/tgbridge/paper/PaperTelegramBridge;", "Ldev/vanutp/tgbridge/common/TelegramBridge;", "plugin", "Ldev/vanutp/tgbridge/paper/PaperBootstrap;", "<init>", "(Ldev/vanutp/tgbridge/paper/PaperBootstrap;)V", "getPlugin", "()Ldev/vanutp/tgbridge/paper/PaperBootstrap;", "logger", "Ldev/vanutp/tgbridge/paper/PaperLogger;", "getLogger", "()Ldev/vanutp/tgbridge/paper/PaperLogger;", "platform", "Ldev/vanutp/tgbridge/paper/PaperPlatform;", "getPlatform", "()Ldev/vanutp/tgbridge/paper/PaperPlatform;", "tgbridge-paper"})
public final class PaperTelegramBridge
extends TelegramBridge {
    @NotNull
    private final PaperBootstrap plugin;
    @NotNull
    private final PaperLogger logger;
    @NotNull
    private final PaperPlatform platform;

    public PaperTelegramBridge(@NotNull PaperBootstrap plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.logger = new PaperLogger(this.plugin);
        this.platform = new PaperPlatform(this.plugin);
        Path configPath = this.getPlatform().getConfigDir().resolve("config-paper.yml");
        Intrinsics.checkNotNull(configPath);
        Files.deleteIfExists(configPath);
        this.addIntegration(new ChattyV2Compat(this));
        this.addIntegration(new ChattyV3Compat(this));
        this.addIntegration(new HeroChatCompat(this));
        this.addIntegration(new CarbonChatCompat(this));
        this.addIntegration(new EssentialsVanishCompat(this));
        this.addIntegration(new GenericVanishCompat(this));
        this.addIntegration(new SuperVanishCompat(this));
        this.addIntegration(new IncompatibleChatPluginCompat(this));
        this.addIntegration(new VoiceMessagesPaperCompat(this));
    }

    @NotNull
    public final PaperBootstrap getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public PaperLogger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public PaperPlatform getPlatform() {
        return this.platform;
    }
}

