/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.kotlinx.serialization.json.internal;

import java.util.Map;
import tgbridge.shaded.kotlin.Metadata;
import tgbridge.shaded.kotlin.NoWhenBranchMatchedException;
import tgbridge.shaded.kotlin.Unit;
import tgbridge.shaded.kotlin.jvm.functions.Function1;
import tgbridge.shaded.kotlin.jvm.internal.Intrinsics;
import tgbridge.shaded.kotlinx.serialization.json.Json;
import tgbridge.shaded.kotlinx.serialization.json.JsonArray;
import tgbridge.shaded.kotlinx.serialization.json.JsonArraySerializer;
import tgbridge.shaded.kotlinx.serialization.json.JsonElement;
import tgbridge.shaded.kotlinx.serialization.json.JsonObject;
import tgbridge.shaded.kotlinx.serialization.json.JsonObjectSerializer;
import tgbridge.shaded.kotlinx.serialization.json.JsonPrimitive;
import tgbridge.shaded.kotlinx.serialization.json.internal.JsonExceptionsKt;
import tgbridge.shaded.kotlinx.serialization.json.internal.JsonTreeEncoder;
import tgbridge.shaded.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltgbridge/shaded/kotlinx/serialization/json/internal/JsonTreeMapEncoder;", "Ltgbridge/shaded/kotlinx/serialization/json/internal/JsonTreeEncoder;", "json", "Ltgbridge/shaded/kotlinx/serialization/json/Json;", "nodeConsumer", "Ltgbridge/shaded/kotlin/Function1;", "Ltgbridge/shaded/kotlinx/serialization/json/JsonElement;", "", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlin/jvm/functions/Function1;)V", "tag", "", "isKey", "", "putElement", "key", "element", "getCurrent", "tgbridge.shaded.kotlinx-serialization-json"})
final class JsonTreeMapEncoder
extends JsonTreeEncoder {
    private String tag;
    private boolean isKey;

    public JsonTreeMapEncoder(@NotNull Json json, @NotNull Function1<? super JsonElement, Unit> nodeConsumer) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(nodeConsumer, "nodeConsumer");
        super(json, nodeConsumer);
        this.isKey = true;
    }

    @Override
    public void putElement(@NotNull String key, @NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(element, "element");
        if (this.isKey) {
            JsonElement jsonElement = element;
            if (!(jsonElement instanceof JsonPrimitive)) {
                if (jsonElement instanceof JsonObject) {
                    throw JsonExceptionsKt.InvalidKeyKindException(JsonObjectSerializer.INSTANCE.getDescriptor());
                }
                if (jsonElement instanceof JsonArray) {
                    throw JsonExceptionsKt.InvalidKeyKindException(JsonArraySerializer.INSTANCE.getDescriptor());
                }
                throw new NoWhenBranchMatchedException();
            }
            this.tag = ((JsonPrimitive)element).getContent();
            this.isKey = false;
        } else {
            Map<String, JsonElement> map = this.getContent();
            String string = this.tag;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException("tag");
                string = null;
            }
            map.put(string, element);
            this.isKey = true;
        }
    }

    @Override
    @NotNull
    public JsonElement getCurrent() {
        return new JsonObject(this.getContent());
    }
}

