/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.retrofit2;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import tgbridge.shaded.okhttp3.Call;
import tgbridge.shaded.okhttp3.MediaType;
import tgbridge.shaded.okhttp3.Request;
import tgbridge.shaded.okhttp3.ResponseBody;
import tgbridge.shaded.okio.Buffer;
import tgbridge.shaded.okio.BufferedSource;
import tgbridge.shaded.okio.ForwardingSource;
import tgbridge.shaded.okio.Okio;
import tgbridge.shaded.okio.Timeout;
import tgbridge.shaded.retrofit2.Call;
import tgbridge.shaded.retrofit2.Callback;
import tgbridge.shaded.retrofit2.Converter;
import tgbridge.shaded.retrofit2.RequestFactory;
import tgbridge.shaded.retrofit2.Response;
import tgbridge.shaded.retrofit2.Utils;

final class OkHttpCall<T>
implements Call<T> {
    private final RequestFactory requestFactory;
    private final Object instance;
    private final Object[] args;
    private final Call.Factory callFactory;
    private final Converter<ResponseBody, T> responseConverter;
    private volatile boolean canceled;
    @Nullable
    @GuardedBy(value="this")
    private tgbridge.shaded.okhttp3.Call rawCall;
    @Nullable
    @GuardedBy(value="this")
    private Throwable creationFailure;
    @GuardedBy(value="this")
    private boolean executed;

    OkHttpCall(RequestFactory requestFactory, Object instance, Object[] args2, Call.Factory callFactory, Converter<ResponseBody, T> responseConverter) {
        this.requestFactory = requestFactory;
        this.instance = instance;
        this.args = args2;
        this.callFactory = callFactory;
        this.responseConverter = responseConverter;
    }

    @Override
    public OkHttpCall<T> clone() {
        return new OkHttpCall<T>(this.requestFactory, this.instance, this.args, this.callFactory, this.responseConverter);
    }

    @Override
    public synchronized Request request() {
        try {
            return this.getRawCall().request();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create request.", e);
        }
    }

    @Override
    public synchronized Timeout timeout() {
        try {
            return this.getRawCall().timeout();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create call.", e);
        }
    }

    @GuardedBy(value="this")
    private tgbridge.shaded.okhttp3.Call getRawCall() throws IOException {
        tgbridge.shaded.okhttp3.Call call2 = this.rawCall;
        if (call2 != null) {
            return call2;
        }
        if (this.creationFailure != null) {
            if (this.creationFailure instanceof IOException) {
                throw (IOException)this.creationFailure;
            }
            if (this.creationFailure instanceof RuntimeException) {
                throw (RuntimeException)this.creationFailure;
            }
            throw (Error)this.creationFailure;
        }
        try {
            this.rawCall = this.createRawCall();
            return this.rawCall;
        }
        catch (IOException | Error | RuntimeException e) {
            Utils.throwIfFatal(e);
            this.creationFailure = e;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(final Callback<T> callback) {
        Throwable failure;
        tgbridge.shaded.okhttp3.Call call2;
        Objects.requireNonNull(callback, "callback == null");
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            call2 = this.rawCall;
            failure = this.creationFailure;
            if (call2 == null && failure == null) {
                try {
                    call2 = this.rawCall = this.createRawCall();
                }
                catch (Throwable t) {
                    Utils.throwIfFatal(t);
                    failure = this.creationFailure = t;
                }
            }
        }
        if (failure != null) {
            callback.onFailure(this, failure);
            return;
        }
        if (this.canceled) {
            call2.cancel();
        }
        call2.enqueue(new tgbridge.shaded.okhttp3.Callback(){

            @Override
            public void onResponse(tgbridge.shaded.okhttp3.Call call2, tgbridge.shaded.okhttp3.Response rawResponse) {
                Response response;
                try {
                    response = OkHttpCall.this.parseResponse(rawResponse);
                }
                catch (Throwable e) {
                    Utils.throwIfFatal(e);
                    this.callFailure(e);
                    return;
                }
                try {
                    callback.onResponse(OkHttpCall.this, response);
                }
                catch (Throwable t) {
                    Utils.throwIfFatal(t);
                    t.printStackTrace();
                }
            }

            @Override
            public void onFailure(tgbridge.shaded.okhttp3.Call call2, IOException e) {
                this.callFailure(e);
            }

            private void callFailure(Throwable e) {
                try {
                    callback.onFailure(OkHttpCall.this, e);
                }
                catch (Throwable t) {
                    Utils.throwIfFatal(t);
                    t.printStackTrace();
                }
            }
        });
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<T> execute() throws IOException {
        tgbridge.shaded.okhttp3.Call call2;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            call2 = this.getRawCall();
        }
        if (this.canceled) {
            call2.cancel();
        }
        return this.parseResponse(call2.execute());
    }

    private tgbridge.shaded.okhttp3.Call createRawCall() throws IOException {
        tgbridge.shaded.okhttp3.Call call2 = this.callFactory.newCall(this.requestFactory.create(this.instance, this.args));
        if (call2 == null) {
            throw new NullPointerException("Call.Factory returned null.");
        }
        return call2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response<T> parseResponse(tgbridge.shaded.okhttp3.Response rawResponse) throws IOException {
        ResponseBody rawBody = rawResponse.body();
        int code = (rawResponse = rawResponse.newBuilder().body(new NoContentResponseBody(rawBody.contentType(), rawBody.contentLength())).build()).code();
        if (code < 200 || code >= 300) {
            try {
                ResponseBody bufferedBody = Utils.buffer(rawBody);
                Response response = Response.error(bufferedBody, rawResponse);
                return response;
            }
            finally {
                rawBody.close();
            }
        }
        if (code == 204 || code == 205) {
            rawBody.close();
            return Response.success(null, rawResponse);
        }
        ExceptionCatchingResponseBody catchingBody = new ExceptionCatchingResponseBody(rawBody);
        try {
            T body = this.responseConverter.convert(catchingBody);
            return Response.success(body, rawResponse);
        }
        catch (RuntimeException e) {
            catchingBody.throwIfCaught();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        tgbridge.shaded.okhttp3.Call call2;
        this.canceled = true;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            call2 = this.rawCall;
        }
        if (call2 != null) {
            call2.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        if (this.canceled) {
            return true;
        }
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            return this.rawCall != null && this.rawCall.isCanceled();
        }
    }

    static final class ExceptionCatchingResponseBody
    extends ResponseBody {
        private final ResponseBody delegate;
        private final BufferedSource delegateSource;
        @Nullable
        IOException thrownException;

        ExceptionCatchingResponseBody(ResponseBody delegate) {
            this.delegate = delegate;
            this.delegateSource = Okio.buffer(new ForwardingSource(delegate.source()){

                @Override
                public long read(Buffer sink2, long byteCount) throws IOException {
                    try {
                        return super.read(sink2, byteCount);
                    }
                    catch (IOException e) {
                        thrownException = e;
                        throw e;
                    }
                }
            });
        }

        @Override
        public MediaType contentType() {
            return this.delegate.contentType();
        }

        @Override
        public long contentLength() {
            return this.delegate.contentLength();
        }

        @Override
        public BufferedSource source() {
            return this.delegateSource;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        void throwIfCaught() throws IOException {
            if (this.thrownException != null) {
                throw this.thrownException;
            }
        }
    }

    static final class NoContentResponseBody
    extends ResponseBody {
        @Nullable
        private final MediaType contentType;
        private final long contentLength;

        NoContentResponseBody(@Nullable MediaType contentType, long contentLength) {
            this.contentType = contentType;
            this.contentLength = contentLength;
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }

        @Override
        public BufferedSource source() {
            throw new IllegalStateException("Cannot read raw response body of a converted body.");
        }
    }
}

