/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.snakeyaml.engine.kmp.scanner;

import java.io.IOException;
import tgbridge.shaded.kotlin.Metadata;
import tgbridge.shaded.kotlin.collections.ArraysKt;
import tgbridge.shaded.kotlin.jvm.JvmOverloads;
import tgbridge.shaded.kotlin.jvm.JvmStatic;
import tgbridge.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import tgbridge.shaded.kotlin.jvm.internal.Intrinsics;
import tgbridge.shaded.kotlin.ranges.RangesKt;
import tgbridge.shaded.kotlin.text.StringsKt;
import tgbridge.shaded.okio.Buffer;
import tgbridge.shaded.okio.BufferedSource;
import tgbridge.shaded.okio.ByteString;
import tgbridge.shaded.okio.Okio;
import tgbridge.shaded.okio.Source;
import tgbridge.shaded.org.jetbrains.annotations.NotNull;
import tgbridge.shaded.org.jetbrains.annotations.Nullable;
import tgbridge.shaded.snakeyaml.engine.kmp.api.LoadSettings;
import tgbridge.shaded.snakeyaml.engine.kmp.common.CharConstants;
import tgbridge.shaded.snakeyaml.engine.kmp.exceptions.Mark;
import tgbridge.shaded.snakeyaml.engine.kmp.exceptions.ReaderException;
import tgbridge.shaded.snakeyaml.engine.kmp.exceptions.YamlEngineException;
import tgbridge.shaded.snakeyaml.engine.kmp.internal.utils.CharSequenceExtensionsKt;
import tgbridge.shaded.snakeyaml.engine.kmp.internal.utils.Character;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 +2\u00020\u0001:\u0001+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0012\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\u0011H\u0007J\u0006\u0010#\u001a\u00020\u0011J\u000e\u0010#\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010$\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0011J\u000e\u0010%\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0011J\u0012\u0010&\u001a\u00020\r2\b\b\u0002\u0010'\u001a\u00020\u0011H\u0002J\b\u0010(\u001a\u00020!H\u0002J\u0010\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0006\u0010*\u001a\u00020!R\u000e\u0010\u0004\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u001e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006,"}, d2={"Ltgbridge/shaded/snakeyaml/engine/kmp/scanner/StreamReader;", "", "loadSettings", "Ltgbridge/shaded/snakeyaml/engine/kmp/api/LoadSettings;", "stream", "Ltgbridge/shaded/okio/Source;", "<init>", "(Lit/krzeminski/snakeyaml/engine/kmp/api/LoadSettings;Lokio/Source;)V", "", "(Lit/krzeminski/snakeyaml/engine/kmp/api/LoadSettings;Ljava/lang/String;)V", "Ltgbridge/shaded/okio/BufferedSource;", "name", "useMarks", "", "codePointsWindow", "", "dataLength", "", "pointer", "eof", "value", "index", "getIndex", "()I", "documentIndex", "getDocumentIndex", "line", "getLine", "column", "getColumn", "getMark", "Ltgbridge/shaded/snakeyaml/engine/kmp/exceptions/Mark;", "forward", "", "length", "peek", "prefix", "prefixForward", "ensureEnoughData", "size", "update", "moveIndices", "resetDocumentIndex", "Companion", "snakeyaml-engine-kmp"})
public final class StreamReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource stream;
    @NotNull
    private final String name;
    private final boolean useMarks;
    @NotNull
    private int[] codePointsWindow;
    private int dataLength;
    private int pointer;
    private boolean eof;
    private int index;
    private int documentIndex;
    private int line;
    private int column;

    public StreamReader(@NotNull LoadSettings loadSettings, @NotNull Source stream) {
        Intrinsics.checkNotNullParameter(loadSettings, "loadSettings");
        Intrinsics.checkNotNullParameter(stream, "stream");
        this.stream = stream instanceof BufferedSource ? (BufferedSource)stream : Okio.buffer(stream);
        this.name = loadSettings.label;
        this.useMarks = loadSettings.useMarks;
        this.codePointsWindow = new int[0];
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getDocumentIndex() {
        return this.documentIndex;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    public StreamReader(@NotNull LoadSettings loadSettings, @NotNull String stream) {
        Intrinsics.checkNotNullParameter(loadSettings, "loadSettings");
        Intrinsics.checkNotNullParameter(stream, "stream");
        this(loadSettings, new Buffer().write(ByteString.Companion.encodeUtf8(stream)));
    }

    @Nullable
    public final Mark getMark() {
        if (!this.useMarks) {
            return null;
        }
        return new Mark(this.name, this.index, this.line, this.column, ArraysKt.asList(this.codePointsWindow), this.pointer);
    }

    @JvmOverloads
    public final void forward(int length) {
        for (int i = 0; i < length; ++i) {
            int it = i;
            boolean bl = false;
            if (!StreamReader.ensureEnoughData$default(this, 0, 1, null)) continue;
            int n = this.pointer;
            this.pointer = n + 1;
            int c = this.codePointsWindow[n];
            this.moveIndices(1);
            if (CharConstants.LINEBR.has(c) || c == 13 && StreamReader.ensureEnoughData$default(this, 0, 1, null) && this.codePointsWindow[this.pointer] != 10) {
                n = this.line;
                this.line = n + 1;
                this.column = 0;
                continue;
            }
            if (c == 65279) continue;
            n = this.column;
            this.column = n + 1;
        }
    }

    public static /* synthetic */ void forward$default(StreamReader streamReader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        streamReader.forward(n);
    }

    public final int peek() {
        return StreamReader.ensureEnoughData$default(this, 0, 1, null) ? this.codePointsWindow[this.pointer] : 0;
    }

    public final int peek(int index) {
        return this.ensureEnoughData(index) ? this.codePointsWindow[this.pointer + index] : 0;
    }

    @NotNull
    public final String prefix(int length) {
        if (length == 0) {
            return "";
        }
        int stringLength = this.ensureEnoughData(length) ? length : RangesKt.coerceAtMost(length, this.dataLength - this.pointer);
        return ArraysKt.joinToString$default(StreamReader.Companion.copyOfRangeSafe(this.codePointsWindow, this.pointer, this.pointer + stringLength), (CharSequence)"", null, null, 0, null, StreamReader::prefix$lambda$1, 30, null);
    }

    @NotNull
    public final String prefixForward(int length) {
        String prefix = this.prefix(length);
        this.pointer += length;
        this.moveIndices(length);
        this.column += length;
        return prefix;
    }

    private final boolean ensureEnoughData(int size) {
        if (!this.eof && this.pointer + size >= this.dataLength) {
            this.update();
        }
        return this.pointer + size < this.dataLength;
    }

    static /* synthetic */ boolean ensureEnoughData$default(StreamReader streamReader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return streamReader.ensureEnoughData(n);
    }

    private final void update() {
        try {
            String buffer = this.stream.readUtf8();
            int read = buffer.length();
            if (read > 0) {
                int cpIndex = this.dataLength - this.pointer;
                this.codePointsWindow = StreamReader.Companion.copyOfRangeSafe(this.codePointsWindow, this.pointer, this.dataLength + read);
                Integer nonPrintable = null;
                int i = 0;
                while (i < read) {
                    int codePoint;
                    this.codePointsWindow[cpIndex] = codePoint = CharSequenceExtensionsKt.codePointAt(buffer, i);
                    if (Companion.isPrintable(codePoint)) {
                        i += Character.INSTANCE.charCount$snakeyaml_engine_kmp(codePoint);
                    } else {
                        nonPrintable = codePoint;
                        i = read;
                    }
                    ++cpIndex;
                }
                this.dataLength = cpIndex;
                this.pointer = 0;
                if (nonPrintable != null) {
                    throw new ReaderException(this.name, cpIndex - 1, nonPrintable, "special characters are not allowed");
                }
            } else {
                this.eof = true;
            }
        }
        catch (IOException ioe) {
            throw new YamlEngineException(ioe);
        }
    }

    private final void moveIndices(int length) {
        this.index += length;
        this.documentIndex += length;
    }

    public final void resetDocumentIndex() {
        this.documentIndex = 0;
    }

    @JvmOverloads
    public final void forward() {
        StreamReader.forward$default(this, 0, 1, null);
    }

    private static final CharSequence prefix$lambda$1(int it) {
        return StringsKt.concatToString(Character.INSTANCE.toChars$snakeyaml_engine_kmp(it));
    }

    @JvmStatic
    public static final boolean isPrintable(@NotNull String data) {
        return Companion.isPrintable(data);
    }

    @JvmStatic
    public static final boolean isPrintable(int c) {
        return Companion.isPrintable(c);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Ltgbridge/shaded/snakeyaml/engine/kmp/scanner/StreamReader$Companion;", "", "<init>", "()V", "isPrintable", "", "data", "", "c", "", "copyOfRangeSafe", "", "fromIndex", "toIndex", "snakeyaml-engine-kmp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isPrintable(@NotNull String data) {
            int codePoint;
            Intrinsics.checkNotNullParameter(data, "data");
            int length = data.length();
            for (int offset = 0; offset < length; offset += Character.INSTANCE.charCount$snakeyaml_engine_kmp(codePoint)) {
                codePoint = CharSequenceExtensionsKt.codePointAt(data, offset);
                if (this.isPrintable(codePoint)) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isPrintable(int c) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if (32 <= c) {
                if (c < 127) {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if (c == 9) return true;
            if (c == 10) return true;
            if (c == 13) return true;
            if (c == 133) return true;
            if (160 <= c) {
                if (c < 55296) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if (57344 <= c) {
                if (c < 65534) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (65536 > c) return false;
            if (c >= 0x110000) return false;
            return true;
        }

        private final int[] copyOfRangeSafe(int[] $this$copyOfRangeSafe, int fromIndex, int toIndex) {
            int n = toIndex - fromIndex;
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                Integer n3 = ArraysKt.getOrNull($this$copyOfRangeSafe, fromIndex + n2);
                nArray[n2] = n3 != null ? n3 : 0;
            }
            return nArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

