/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.okio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tgbridge.shaded.okio.FileHandle;
import tgbridge.shaded.okio.FileMetadata;
import tgbridge.shaded.okio.FileSystem;
import tgbridge.shaded.okio.JvmFileHandle;
import tgbridge.shaded.okio.Okio;
import tgbridge.shaded.okio.Path;
import tgbridge.shaded.okio.Sink;
import tgbridge.shaded.okio.Source;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u000fJ\u001f\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001dJ\u001f\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001bJ\u0019\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b#\u0010$J'\u0010%\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010'\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b'\u0010\nJ\u0017\u0010\u000b\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010)J\u000f\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\b+\u0010,J\u0013\u0010-\u001a\u00020\r*\u00020\u0004H\u0002\u00a2\u0006\u0004\b-\u0010.J\u0013\u0010/\u001a\u00020\r*\u00020\u0004H\u0002\u00a2\u0006\u0004\b/\u0010.\u00a8\u00060"}, d2={"Ltgbridge/shaded/okio/JvmSystemFileSystem;", "Ltgbridge/shaded/okio/FileSystem;", "<init>", "()V", "Ltgbridge/shaded/okio/Path;", "file", "", "mustExist", "Ltgbridge/shaded/okio/Sink;", "appendingSink", "(Ltgbridge/shaded/okio/Path;Z)Ltgbridge/shaded/okio/Sink;", "source", "target", "", "atomicMove", "(Ltgbridge/shaded/okio/Path;Ltgbridge/shaded/okio/Path;)V", "path", "canonicalize", "(Ltgbridge/shaded/okio/Path;)Ltgbridge/shaded/okio/Path;", "dir", "mustCreate", "createDirectory", "(Ltgbridge/shaded/okio/Path;Z)V", "createSymlink", "delete", "", "list", "(Ltgbridge/shaded/okio/Path;)Ljava/util/List;", "throwOnFailure", "(Ltgbridge/shaded/okio/Path;Z)Ljava/util/List;", "listOrNull", "Ltgbridge/shaded/okio/FileMetadata;", "metadataOrNull", "(Ltgbridge/shaded/okio/Path;)Ltgbridge/shaded/okio/FileMetadata;", "Ltgbridge/shaded/okio/FileHandle;", "openReadOnly", "(Ltgbridge/shaded/okio/Path;)Ltgbridge/shaded/okio/FileHandle;", "openReadWrite", "(Ltgbridge/shaded/okio/Path;ZZ)Ltgbridge/shaded/okio/FileHandle;", "sink", "Ltgbridge/shaded/okio/Source;", "(Ltgbridge/shaded/okio/Path;)Ltgbridge/shaded/okio/Source;", "", "toString", "()Ljava/lang/String;", "requireCreate", "(Ltgbridge/shaded/okio/Path;)V", "requireExist", "tgbridge.shaded.okio"})
@SourceDebugExtension(value={"SMAP\nJvmSystemFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSystemFileSystem.kt\nokio/JvmSystemFileSystem\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,158:1\n11400#2,3:159\n*S KotlinDebug\n*F\n+ 1 JvmSystemFileSystem.kt\nokio/JvmSystemFileSystem\n*L\n77#1:159,3\n*E\n"})
public class JvmSystemFileSystem
extends FileSystem {
    @Override
    @NotNull
    public Path canonicalize(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File canonicalFile = path.toFile().getCanonicalFile();
        if (!canonicalFile.exists()) {
            throw new FileNotFoundException("no such file");
        }
        Intrinsics.checkNotNull((Object)canonicalFile);
        return Path.Companion.get$default(Path.Companion, canonicalFile, false, 1, null);
    }

    @Override
    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file2 = path.toFile();
        boolean isRegularFile = file2.isFile();
        boolean isDirectory = file2.isDirectory();
        long lastModifiedAtMillis = file2.lastModified();
        long size = file2.length();
        if (!(isRegularFile || isDirectory || lastModifiedAtMillis != 0L || size != 0L || file2.exists())) {
            return null;
        }
        return new FileMetadata(isRegularFile, isDirectory, null, size, null, lastModifiedAtMillis, null, null, 128, null);
    }

    @Override
    @NotNull
    public List<Path> list(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        List<Path> list = this.list(dir, true);
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Override
    @Nullable
    public List<Path> listOrNull(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.list(dir, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> list(Path dir, boolean throwOnFailure) {
        void destination$iv;
        void $this$mapTo$iv;
        File file2 = dir.toFile();
        String[] entries = file2.list();
        if (entries == null) {
            if (throwOnFailure) {
                if (!file2.exists()) {
                    throw new FileNotFoundException("no such file: " + dir);
                }
                throw new IOException("failed to list " + dir);
            }
            return null;
        }
        String[] stringArray = entries;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv;
            void var12_11 = item$iv = $this$mapTo$iv[i];
            void var14_13 = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            var14_13.add(dir.resolve((String)it));
        }
        List result = (List)destination$iv;
        CollectionsKt.sort((List)result);
        return result;
    }

    @Override
    @NotNull
    public FileHandle openReadOnly(@NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return new JvmFileHandle(false, new RandomAccessFile(file2.toFile(), "r"));
    }

    @Override
    @NotNull
    public FileHandle openReadWrite(@NotNull Path file2, boolean mustCreate, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!(!mustCreate || !mustExist)) {
            boolean bl = false;
            String string = "Cannot require mustCreate and mustExist at the same time.";
            throw new IllegalArgumentException(string.toString());
        }
        if (mustCreate) {
            this.requireCreate(file2);
        }
        if (mustExist) {
            this.requireExist(file2);
        }
        return new JvmFileHandle(true, new RandomAccessFile(file2.toFile(), "rw"));
    }

    @Override
    @NotNull
    public Source source(@NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return Okio.source(file2.toFile());
    }

    @Override
    @NotNull
    public Sink sink(@NotNull Path file2, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (mustCreate) {
            this.requireCreate(file2);
        }
        return Okio.sink$default(file2.toFile(), false, 1, null);
    }

    @Override
    @NotNull
    public Sink appendingSink(@NotNull Path file2, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (mustExist) {
            this.requireExist(file2);
        }
        return Okio.sink(file2.toFile(), true);
    }

    @Override
    public void createDirectory(@NotNull Path dir, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.toFile().mkdir()) {
            boolean alreadyExist;
            FileMetadata fileMetadata = this.metadataOrNull(dir);
            boolean bl = fileMetadata != null ? fileMetadata.isDirectory() : (alreadyExist = false);
            if (alreadyExist) {
                if (mustCreate) {
                    throw new IOException(dir + " already exists.");
                }
                return;
            }
            throw new IOException("failed to create directory: " + dir);
        }
    }

    @Override
    public void atomicMove(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean renamed = source2.toFile().renameTo(target.toFile());
        if (!renamed) {
            throw new IOException("failed to move " + source2 + " to " + target);
        }
    }

    @Override
    public void delete(@NotNull Path path, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Thread.interrupted()) {
            throw new InterruptedIOException("interrupted");
        }
        File file2 = path.toFile();
        boolean deleted = file2.delete();
        if (!deleted) {
            if (file2.exists()) {
                throw new IOException("failed to delete " + path);
            }
            if (mustExist) {
                throw new FileNotFoundException("no such file: " + path);
            }
        }
    }

    @Override
    public void createSymlink(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        throw new IOException("unsupported");
    }

    @NotNull
    public String toString() {
        return "JvmSystemFileSystem";
    }

    private final void requireExist(Path $this$requireExist) {
        if (!this.exists($this$requireExist)) {
            throw new IOException($this$requireExist + " doesn't exist.");
        }
    }

    private final void requireCreate(Path $this$requireCreate) {
        if (this.exists($this$requireCreate)) {
            throw new IOException($this$requireCreate + " already exists.");
        }
    }
}

