/*
 * Decompiled with CFR 0.152.
 */
package dev.vanutp.tgbridge.fabric;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.vanutp.tgbridge.common.models.TgbridgeAdvancementEvent;
import dev.vanutp.tgbridge.common.models.TgbridgeDeathEvent;
import dev.vanutp.tgbridge.common.models.TgbridgeJoinEvent;
import dev.vanutp.tgbridge.common.models.TgbridgeLeaveEvent;
import dev.vanutp.tgbridge.common.models.TgbridgeMcChatMessageEvent;
import dev.vanutp.tgbridge.common.models.TgbridgePlayer;
import dev.vanutp.tgbridge.fabric.CustomEvents;
import dev.vanutp.tgbridge.fabric.FabricEventWrapper;
import dev.vanutp.tgbridge.fabric.FabricTelegramBridge;
import dev.vanutp.tgbridge.fabric.UtilsKt;
import java.lang.reflect.Method;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_185;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_7471;
import org.jetbrains.annotations.NotNull;
import tgbridge.shaded.kyori.adventure.text.Component;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003J\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u0003J\u001d\u0010\u000f\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0003\u00a8\u0006\u0013"}, d2={"Ldev/vanutp/tgbridge/fabric/EventManager;", "", "<init>", "()V", "", "register", "registerChatMessageListener", "registerPlayerDeathListener", "registerPlayerJoinListener", "registerPlayerLeaveListener", "registerPlayerAdvancementListener", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "ctx", "", "onReloadCommand", "(Lcom/mojang/brigadier/context/CommandContext;)I", "onToggleMuteCommand", "registerCommandHandlers", "tgbridge-fabric"})
public final class EventManager {
    @NotNull
    public static final EventManager INSTANCE = new EventManager();

    private EventManager() {
    }

    public final void register() {
        this.registerChatMessageListener();
        this.registerPlayerDeathListener();
        this.registerPlayerJoinListener();
        this.registerPlayerLeaveListener();
        this.registerPlayerAdvancementListener();
        this.registerCommandHandlers();
    }

    private final void registerChatMessageListener() {
        ServerMessageEvents.CHAT_MESSAGE.register(EventManager::registerChatMessageListener$lambda$0);
    }

    private final void registerPlayerDeathListener() {
        CustomEvents.Companion.getPLAYER_DEATH_EVENT().register(EventManager::registerPlayerDeathListener$lambda$1);
    }

    private final void registerPlayerJoinListener() {
        CustomEvents.Companion.getPLAYER_JOIN_EVENT().register(EventManager::registerPlayerJoinListener$lambda$2);
    }

    private final void registerPlayerLeaveListener() {
        CustomEvents.Companion.getPLAYER_LEAVE_EVENT().register(EventManager::registerPlayerLeaveListener$lambda$3);
    }

    private final void registerPlayerAdvancementListener() {
        CustomEvents.Companion.getADVANCEMENT_EARN_EVENT().register(EventManager::registerPlayerAdvancementListener$lambda$4);
    }

    private final int onReloadCommand(CommandContext<class_2168> ctx) {
        boolean res = FabricTelegramBridge.INSTANCE.onReloadCommand(UtilsKt.toTgbridge(ctx));
        return res ? 1 : -1;
    }

    private final int onToggleMuteCommand(CommandContext<class_2168> ctx) {
        boolean res = FabricTelegramBridge.INSTANCE.onToggleMuteCommand(UtilsKt.toTgbridge(ctx));
        return res ? 1 : -1;
    }

    private final void registerCommandHandlers() {
        CommandRegistrationCallback.EVENT.register(EventManager::registerCommandHandlers$lambda$6);
    }

    private static final void registerChatMessageListener$lambda$0(class_7471 message, class_3222 sender, class_2556.class_7602 params) {
        class_2561 class_25612;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (FabricTelegramBridge.INSTANCE.getVersionInfo().getIS_192()) {
            Class<?> cls = message.getClass();
            Method getContent = cls.getMethod("method_44125", new Class[0]);
            Object object = getContent.invoke((Object)message, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.text.Text");
            class_25612 = (class_2561)object;
        } else {
            class_25612 = message.method_46291();
        }
        class_2561 messageContent = class_25612;
        Intrinsics.checkNotNull((Object)sender);
        TgbridgePlayer tgbridgePlayer = UtilsKt.toTgbridge((class_1657)sender);
        Intrinsics.checkNotNull((Object)messageContent);
        Object[] objectArray = new Object[]{message, sender, params};
        FabricTelegramBridge.INSTANCE.onChatMessage(new TgbridgeMcChatMessageEvent(tgbridgePlayer, UtilsKt.toAdventure(messageContent), new FabricEventWrapper(Reflection.getOrCreateKotlinClass(ServerMessageEvents.ChatMessage.class), CollectionsKt.listOf((Object[])objectArray)), null, 8, null));
    }

    private static final void registerPlayerDeathListener$lambda$1(class_3222 player, class_1282 damageSource) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        class_2561 deathMessage = damageSource.method_5506((class_1309)player);
        TgbridgePlayer tgbridgePlayer = UtilsKt.toTgbridge((class_1657)player);
        Intrinsics.checkNotNull((Object)deathMessage);
        Object[] objectArray = new Object[]{player, damageSource};
        FabricTelegramBridge.INSTANCE.onPlayerDeath(new TgbridgeDeathEvent(tgbridgePlayer, UtilsKt.toAdventure(deathMessage), new FabricEventWrapper(Reflection.getOrCreateKotlinClass(CustomEvents.PlayerDeath.class), CollectionsKt.listOf((Object[])objectArray)), null, 8, null));
    }

    private static final void registerPlayerJoinListener$lambda$2(class_3222 player, boolean hasPlayedBefore) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object[] objectArray = new Object[]{player, hasPlayedBefore};
        FabricTelegramBridge.INSTANCE.onPlayerJoin(new TgbridgeJoinEvent(UtilsKt.toTgbridge((class_1657)player), hasPlayedBefore, new FabricEventWrapper(Reflection.getOrCreateKotlinClass(CustomEvents.PlayerJoin.class), CollectionsKt.listOf((Object[])objectArray)), null, false, 24, null));
    }

    private static final void registerPlayerLeaveListener$lambda$3(class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        FabricTelegramBridge.INSTANCE.onPlayerLeave(new TgbridgeLeaveEvent(UtilsKt.toTgbridge((class_1657)player), new FabricEventWrapper(Reflection.getOrCreateKotlinClass(CustomEvents.PlayerLeave.class), CollectionsKt.listOf((Object)player)), null, false, 12, null));
    }

    private static final void registerPlayerAdvancementListener$lambda$4(class_3222 player, class_185 display) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)display, (String)"display");
                if (!display.method_808()) {
                    return;
                }
                object = display.method_815();
                if (object == null || (object = object.name()) == null) break block4;
                String string = ((String)object).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                object = string;
                if (string != null) break block5;
            }
            return;
        }
        Object type = object;
        TgbridgePlayer tgbridgePlayer = UtilsKt.toTgbridge((class_1657)player);
        class_2561 class_25612 = display.method_811();
        Intrinsics.checkNotNullExpressionValue((Object)class_25612, (String)"getTitle(...)");
        Component component = UtilsKt.toAdventure(class_25612);
        class_2561 class_25613 = display.method_817();
        Intrinsics.checkNotNullExpressionValue((Object)class_25613, (String)"getDescription(...)");
        Object[] objectArray = new Object[]{player, display};
        FabricTelegramBridge.INSTANCE.onPlayerAdvancement(new TgbridgeAdvancementEvent(tgbridgePlayer, (String)type, component, UtilsKt.toAdventure(class_25613), new FabricEventWrapper(Reflection.getOrCreateKotlinClass(CustomEvents.AdvancementEarn.class), CollectionsKt.listOf((Object[])objectArray)), null, 32, null));
    }

    private static final boolean registerCommandHandlers$lambda$6$lambda$5(class_2168 it) {
        return it.method_9259(4);
    }

    private static final void registerCommandHandlers$lambda$6(CommandDispatcher dispatcher, class_7157 class_71572, class_2170.class_5364 class_53642) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tgbridge").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(EventManager::registerCommandHandlers$lambda$6$lambda$5)).executes(INSTANCE::onReloadCommand))).then(class_2170.method_9247((String)"toggle").executes(INSTANCE::onToggleMuteCommand)));
    }
}

