/*
 * Decompiled with CFR 0.152.
 */
package dev.vanutp.tgbridge.fabric;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_3518;
import net.minecraft.class_3797;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public final class TgbridgeMixinPlugin
implements IMixinConfigPlugin {
    private static final String version;
    private static final int minor;
    private static final int patch;
    private static final boolean isLte201;
    private static final boolean isLte215;
    private static final Map<String, Boolean> CONDITIONS;

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String className = mixinClassName.replace("dev.vanutp.tgbridge.fabric.mixin.", "");
        return CONDITIONS.getOrDefault(className, true);
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        try (InputStream is = class_3797.class.getResourceAsStream("/version.json");){
            if (is == null) {
                throw new IllegalStateException("Failed to load Minecraft version");
            }
            try (InputStreamReader reader = new InputStreamReader(is);){
                version = class_3518.method_15265((JsonObject)class_3518.method_15255((Reader)reader), (String)"name");
            }
        }
        catch (JsonParseException | IOException exception) {
            throw new IllegalStateException("Failed to load Minecraft version", exception);
        }
        String[] splitVersion = version.split("\\.");
        minor = Integer.parseInt(splitVersion[1]);
        patch = splitVersion.length > 2 ? Integer.parseInt(splitVersion[2]) : 0;
        isLte201 = minor < 20 || minor == 20 && patch <= 1;
        isLte215 = minor < 21 || minor == 21 && patch <= 5;
        CONDITIONS = ImmutableMap.of((Object)"PlayerManagerMixin_201", (Object)isLte201, (Object)"PlayerManagerMixin_modern", (Object)(!isLte201 ? 1 : 0), (Object)"PlayerAdvancementTrackerMixin_201", (Object)isLte201, (Object)"PlayerAdvancementTrackerMixin_modern", (Object)(!isLte201 ? 1 : 0), (Object)"ServerPlayerEntityMixin_215", (Object)isLte215, (Object)"ServerPlayerEntityMixin_modern", (Object)(!isLte215 ? 1 : 0));
    }
}

