/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.kaml;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tgbridge.shaded.kaml.YamlNode;
import tgbridge.shaded.kaml.YamlPath;
import tgbridge.shaded.kaml.YamlScalar;
import tgbridge.shaded.kaml.YamlScalarFormatException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J7\u0010\u001e\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u001a2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00028\u00000\u001b2\u0006\u0010\u001d\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010!\u001a\u00020 \u00a2\u0006\u0004\b!\u0010\"J\r\u0010$\u001a\u00020#\u00a2\u0006\u0004\b$\u0010%J\r\u0010&\u001a\u00020\t\u00a2\u0006\u0004\b&\u0010'J\r\u0010)\u001a\u00020(\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010,\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b.\u0010\rJ\u0010\u0010/\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b/\u0010\rJ\u0010\u00100\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b0\u00101J$\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b2\u00103J\u001a\u00105\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u000104H\u00d6\u0003\u00a2\u0006\u0004\b5\u00106J\u0010\u00107\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b7\u0010\u0016R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00108\u001a\u0004\b9\u0010\rR\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010:\u001a\u0004\b;\u0010<\u00a8\u0006="}, d2={"Ltgbridge/shaded/kaml/YamlScalar;", "Ltgbridge/shaded/kaml/YamlNode;", "", "content", "Ltgbridge/shaded/kaml/YamlPath;", "path", "<init>", "(Ljava/lang/String;Lcom/charleskorn/kaml/YamlPath;)V", "other", "", "equivalentContentTo", "(Ltgbridge/shaded/kaml/YamlNode;)Z", "contentToString", "()Ljava/lang/String;", "", "toByte", "()B", "", "toShort", "()S", "", "toInt", "()I", "", "toLong", "()J", "T", "Lkotlin/Function2;", "converter", "description", "convertToIntegerLikeValue", "(Lkotlin/jvm/functions/Function2;Ljava/lang/String;)Ljava/lang/Object;", "", "toFloat", "()F", "", "toDouble", "()D", "toBoolean", "()Z", "", "toChar", "()C", "newPath", "withPath", "(Ltgbridge/shaded/kaml/YamlPath;)Ltgbridge/shaded/kaml/YamlScalar;", "toString", "component1", "component2", "()Ltgbridge/shaded/kaml/YamlPath;", "copy", "(Ljava/lang/String;Ltgbridge/shaded/kaml/YamlPath;)Ltgbridge/shaded/kaml/YamlScalar;", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "Ljava/lang/String;", "getContent", "Ltgbridge/shaded/kaml/YamlPath;", "getPath", "()Lcom/charleskorn/kaml/YamlPath;", "kaml"})
public final class YamlScalar
extends YamlNode {
    @NotNull
    private final String content;
    @NotNull
    private final YamlPath path;

    public YamlScalar(@NotNull String content, @NotNull YamlPath path) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(path, null);
        this.content = content;
        this.path = path;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @Override
    @NotNull
    public YamlPath getPath() {
        return this.path;
    }

    @Override
    public boolean equivalentContentTo(@NotNull YamlNode other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof YamlScalar && Intrinsics.areEqual((Object)this.content, (Object)((YamlScalar)other).content);
    }

    @Override
    @NotNull
    public String contentToString() {
        return '\'' + this.content + '\'';
    }

    public final byte toByte() {
        return ((Number)this.convertToIntegerLikeValue(toByte.1.INSTANCE, "byte")).byteValue();
    }

    public final short toShort() {
        return ((Number)this.convertToIntegerLikeValue(toShort.1.INSTANCE, "short")).shortValue();
    }

    public final int toInt() {
        return ((Number)this.convertToIntegerLikeValue(toInt.1.INSTANCE, "integer")).intValue();
    }

    public final long toLong() {
        return ((Number)this.convertToIntegerLikeValue(toLong.1.INSTANCE, "long")).longValue();
    }

    private final <T> T convertToIntegerLikeValue(Function2<? super String, ? super Integer, ? extends T> converter, String description) {
        try {
            Object object;
            if (StringsKt.startsWith$default((String)this.content, (String)"0x", (boolean)false, (int)2, null)) {
                String string = this.content.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = converter.invoke((Object)string, (Object)16);
            } else if (StringsKt.startsWith$default((String)this.content, (String)"-0x", (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append('-');
                String string = this.content.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = converter.invoke((Object)stringBuilder.append(string).toString(), (Object)16);
            } else if (StringsKt.startsWith$default((String)this.content, (String)"0o", (boolean)false, (int)2, null)) {
                String string = this.content.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = converter.invoke((Object)string, (Object)8);
            } else if (StringsKt.startsWith$default((String)this.content, (String)"-0o", (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append('-');
                String string = this.content.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = converter.invoke((Object)stringBuilder.append(string).toString(), (Object)8);
            } else {
                object = converter.invoke((Object)this.content, (Object)10);
            }
            return (T)object;
        }
        catch (NumberFormatException e) {
            throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid " + description + " value.", this.getPath(), this.content);
        }
    }

    public final float toFloat() {
        float f;
        switch (this.content) {
            case ".inf": 
            case ".Inf": 
            case ".INF": {
                f = Float.POSITIVE_INFINITY;
                break;
            }
            case "-.inf": 
            case "-.Inf": 
            case "-.INF": {
                f = Float.NEGATIVE_INFINITY;
                break;
            }
            case ".nan": 
            case ".NaN": 
            case ".NAN": {
                f = Float.NaN;
                break;
            }
            default: {
                float f2;
                try {
                    f2 = Float.parseFloat(this.content);
                }
                catch (NumberFormatException e) {
                    throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid floating point value.", this.getPath(), this.content);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid floating point value.", this.getPath(), this.content);
                }
                f = f2;
            }
        }
        return f;
    }

    public final double toDouble() {
        double d;
        switch (this.content) {
            case ".inf": 
            case ".Inf": 
            case ".INF": {
                d = Double.POSITIVE_INFINITY;
                break;
            }
            case "-.inf": 
            case "-.Inf": 
            case "-.INF": {
                d = Double.NEGATIVE_INFINITY;
                break;
            }
            case ".nan": 
            case ".NaN": 
            case ".NAN": {
                d = Double.NaN;
                break;
            }
            default: {
                double d2;
                try {
                    d2 = Double.parseDouble(this.content);
                }
                catch (NumberFormatException e) {
                    throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid floating point value.", this.getPath(), this.content);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid floating point value.", this.getPath(), this.content);
                }
                d = d2;
            }
        }
        return d;
    }

    public final boolean toBoolean() {
        boolean bl;
        switch (this.content) {
            case "true": 
            case "True": 
            case "TRUE": {
                bl = true;
                break;
            }
            case "false": 
            case "FALSE": 
            case "False": {
                bl = false;
                break;
            }
            default: {
                throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid boolean, permitted choices are: true or false", this.getPath(), this.content);
            }
        }
        return bl;
    }

    public final char toChar() {
        Character c = StringsKt.singleOrNull((CharSequence)this.content);
        if (c == null) {
            throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid character value.", this.getPath(), this.content);
        }
        return c.charValue();
    }

    @Override
    @NotNull
    public YamlScalar withPath(@NotNull YamlPath newPath) {
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        return YamlScalar.copy$default(this, null, newPath, 1, null);
    }

    @NotNull
    public String toString() {
        return "scalar @ " + this.getPath() + " : " + this.content;
    }

    @NotNull
    public final String component1() {
        return this.content;
    }

    @NotNull
    public final YamlPath component2() {
        return this.path;
    }

    @NotNull
    public final YamlScalar copy(@NotNull String content, @NotNull YamlPath path) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new YamlScalar(content, path);
    }

    public static /* synthetic */ YamlScalar copy$default(YamlScalar yamlScalar, String string, YamlPath yamlPath, int n, Object object) {
        if ((n & 1) != 0) {
            string = yamlScalar.content;
        }
        if ((n & 2) != 0) {
            yamlPath = yamlScalar.path;
        }
        return yamlScalar.copy(string, yamlPath);
    }

    public int hashCode() {
        int result = this.content.hashCode();
        result = result * 31 + this.path.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof YamlScalar)) {
            return false;
        }
        YamlScalar yamlScalar = (YamlScalar)other;
        if (!Intrinsics.areEqual((Object)this.content, (Object)yamlScalar.content)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.path, (Object)yamlScalar.path);
    }
}

