/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.retrofit2;

import android.annotation.TargetApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import tgbridge.shaded.retrofit2.CallAdapter;
import tgbridge.shaded.retrofit2.CompletableFutureCallAdapterFactory;
import tgbridge.shaded.retrofit2.Converter;
import tgbridge.shaded.retrofit2.DefaultCallAdapterFactory;
import tgbridge.shaded.retrofit2.OptionalConverterFactory;

class BuiltInFactories {
    BuiltInFactories() {
    }

    List<? extends CallAdapter.Factory> createDefaultCallAdapterFactories(@Nullable Executor callbackExecutor) {
        return Collections.singletonList(new DefaultCallAdapterFactory(callbackExecutor));
    }

    List<? extends Converter.Factory> createDefaultConverterFactories() {
        return Collections.emptyList();
    }

    @TargetApi(value=24)
    static final class Java8
    extends BuiltInFactories {
        Java8() {
        }

        @Override
        List<? extends CallAdapter.Factory> createDefaultCallAdapterFactories(@Nullable Executor callbackExecutor) {
            return Arrays.asList(new CompletableFutureCallAdapterFactory(), new DefaultCallAdapterFactory(callbackExecutor));
        }

        @Override
        List<? extends Converter.Factory> createDefaultConverterFactories() {
            return Collections.singletonList(new OptionalConverterFactory());
        }
    }
}

