/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sweetygarden;

import com.mojang.serialization.Codec;
import net.mcreator.sweetygarden.configuration.SweetyGardenConfigConfiguration;
import net.mcreator.sweetygarden.init.SweetyGardenModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DryBaileyaFeature
extends Feature<NoneFeatureConfiguration> {
    public DryBaileyaFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        int flowersPlaced = 0;
        int chance = 60;
        if (!((Boolean)SweetyGardenConfigConfiguration.BAILEYA.get()).booleanValue()) {
            return false;
        }
        for (int i = 0; i < 30; ++i) {
            int xOffset = random.nextInt(6) - 3;
            int zOffset = random.nextInt(11) - 5;
            BlockPos pos = origin.offset(xOffset, 0, zOffset);
            BlockState stateAt = level.getBlockState((pos = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, pos)).below());
            if (stateAt.is(Blocks.SAND)) {
                level.setBlock(pos.below(), Blocks.SANDSTONE.defaultBlockState(), 2);
                if (random.nextInt(100) < chance && level.getBlockState(pos).isAir()) {
                    level.setBlock(pos, ((Block)SweetyGardenModBlocks.BAILEYA.get()).defaultBlockState(), 2);
                    ++flowersPlaced;
                    chance -= 10;
                }
            }
            if (flowersPlaced >= 7) break;
        }
        return true;
    }
}

