/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sweetygarden;

import com.mojang.serialization.Codec;
import net.mcreator.sweetygarden.configuration.SweetyGardenConfigConfiguration;
import net.mcreator.sweetygarden.init.SweetyGardenModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PassionFlowerTrunkFeature
extends Feature<NoneFeatureConfiguration> {
    public PassionFlowerTrunkFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        if (!((Boolean)SweetyGardenConfigConfiguration.PASSION_FLOWER.get()).booleanValue()) {
            return false;
        }
        if (!world.getBlockState(origin.below()).isFaceSturdy((BlockGetter)world, origin.below(), Direction.UP)) {
            return false;
        }
        RandomSource random = context.random();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        this.placeHorizontalTrunk(world, origin, random, direction);
        return true;
    }

    private void placeHorizontalTrunk(WorldGenLevel world, BlockPos basePos, RandomSource random, Direction direction) {
        world.setBlock(basePos, Blocks.JUNGLE_LOG.defaultBlockState(), 3);
        BlockPos topOfBase = basePos.above();
        if (world.isEmptyBlock(topOfBase)) {
            float topChance = random.nextFloat();
            if (topChance < 0.2f) {
                world.setBlock(topOfBase, Blocks.MOSS_CARPET.defaultBlockState(), 3);
            } else if (topChance < 0.4f) {
                world.setBlock(topOfBase, Blocks.BROWN_MUSHROOM.defaultBlockState(), 3);
            } else if (topChance < 0.8f) {
                world.setBlock(topOfBase, (BlockState)((Block)SweetyGardenModBlocks.PASSION_FLOWER.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP), 3);
            }
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            BlockPos sidePos = basePos.relative(face);
            if (!world.isEmptyBlock(sidePos)) continue;
            if (random.nextFloat() < 0.4f) {
                world.setBlock(sidePos, (BlockState)((Block)SweetyGardenModBlocks.PASSION_FLOWER.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)face), 3);
            }
            if (!(random.nextFloat() < 0.3f)) continue;
            world.setBlock(sidePos, (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.getPropertyForFace((Direction)face.getOpposite()), (Comparable)Boolean.valueOf(true)), 3);
        }
        BlockPos sideBasePos = basePos.relative(direction);
        BlockPos trunkStart = sideBasePos.relative(direction);
        if (world.getBlockState(sideBasePos.below()).isFaceSturdy((BlockGetter)world, sideBasePos.below(), Direction.UP)) {
            if (random.nextFloat() < 0.3f && world.isEmptyBlock(sideBasePos)) {
                world.setBlock(sideBasePos, (BlockState)((Block)SweetyGardenModBlocks.PASSION_FLOWER.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP), 3);
            } else if (random.nextFloat() < 0.5f && world.isEmptyBlock(sideBasePos)) {
                world.setBlock(sideBasePos, Blocks.MOSS_CARPET.defaultBlockState(), 3);
            }
        }
        if (!world.getBlockState(trunkStart.below()).isFaceSturdy((BlockGetter)world, trunkStart.below(), Direction.UP)) {
            return;
        }
        int trunkLength = 3 + random.nextInt(3);
        Direction.Axis axis = direction.getAxis();
        BlockPos.MutableBlockPos current = trunkStart.mutable();
        for (int i = 0; i < trunkLength && !world.getBlockState((BlockPos)current).canOcclude(); ++i) {
            BlockPos below;
            boolean belowSturdy;
            if (i > 0 && !(belowSturdy = world.getBlockState(below = current.below()).isFaceSturdy((BlockGetter)world, below, Direction.UP))) {
                boolean supported = false;
                for (Direction perp : Direction.Plane.HORIZONTAL) {
                    BlockPos adj = current.relative(perp);
                    if (!world.getBlockState(adj.below()).isFaceSturdy((BlockGetter)world, adj.below(), Direction.UP)) continue;
                    supported = true;
                    break;
                }
                if (!supported) break;
            }
            world.setBlock((BlockPos)current, (BlockState)Blocks.JUNGLE_LOG.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis), 3);
            BlockPos top = current.above();
            if (world.isEmptyBlock(top) && random.nextFloat() < 0.35f) {
                world.setBlock(top, (BlockState)((Block)SweetyGardenModBlocks.PASSION_FLOWER.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP), 3);
            }
            if (world.isEmptyBlock(top) && random.nextFloat() < 0.25f) {
                world.setBlock(top, Blocks.MOSS_CARPET.defaultBlockState(), 3);
            }
            for (Direction side : Direction.Plane.HORIZONTAL) {
                if (side.getAxis() == axis) continue;
                BlockPos sideFlower = current.relative(side);
                BlockState sideState = world.getBlockState(sideFlower);
                if (!world.isEmptyBlock(sideFlower) && !sideState.is(Blocks.SHORT_GRASS) && !sideState.is(Blocks.FERN)) continue;
                if (random.nextFloat() < 0.25f) {
                    world.setBlock(sideFlower, (BlockState)((Block)SweetyGardenModBlocks.PASSION_FLOWER.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)side), 3);
                    continue;
                }
                if (!(random.nextFloat() < 0.5f)) continue;
                world.setBlock(sideFlower, (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.getPropertyForFace((Direction)side.getOpposite()), (Comparable)Boolean.valueOf(true)), 3);
            }
            current.move(direction);
        }
    }
}

