/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sweetygarden;

import com.mojang.serialization.Codec;
import net.mcreator.sweetygarden.configuration.SweetyGardenConfigConfiguration;
import net.mcreator.sweetygarden.init.SweetyGardenModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SnowdropSpruceTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public SnowdropSpruceTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        ChunkGenerator generator = context.chunkGenerator();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        BlockPos below = origin.below();
        BlockState stateAtBelow = level.getBlockState(below);
        BlockState stateAtOrigin = level.getBlockState(origin);
        if (!((Boolean)SweetyGardenConfigConfiguration.SNOWDROP.get()).booleanValue()) {
            return false;
        }
        if (!stateAtOrigin.isAir() || !stateAtBelow.is(BlockTags.DIRT)) {
            return false;
        }
        try {
            Registry lookup = level.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE);
            Holder.Reference spruceTreeHolder = lookup.getOrThrow(TreeFeatures.SPRUCE);
            boolean success = ((ConfiguredFeature)spruceTreeHolder.value()).place(level, generator, random, origin);
            if (!success) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        this.decorateWithSnowdrops(level, origin, random);
        return true;
    }

    private void decorateWithSnowdrops(WorldGenLevel level, BlockPos origin, RandomSource random) {
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                if (Math.abs(dx) == 2 && Math.abs(dz) == 2) continue;
                BlockPos pos = origin.offset(dx, 0, dz);
                BlockPos grassCheckPos = null;
                for (int dy = 0; dy <= 2; ++dy) {
                    BlockPos check = pos.below(dy);
                    if (!level.getBlockState(check).is(Blocks.GRASS_BLOCK)) continue;
                    grassCheckPos = check.above();
                    break;
                }
                if (grassCheckPos == null || !level.getBlockState(grassCheckPos).isAir()) continue;
                float chance = random.nextFloat();
                if (chance < 0.3f) {
                    level.setBlock(grassCheckPos, ((Block)SweetyGardenModBlocks.SNOWDROP.get()).defaultBlockState(), 2);
                    continue;
                }
                if (!(chance < 0.6f)) continue;
                level.setBlock(grassCheckPos, Blocks.SHORT_GRASS.defaultBlockState(), 2);
            }
        }
    }
}

