/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sweetygarden;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.mcreator.sweetygarden.DryBaileyaFeature;
import net.mcreator.sweetygarden.PassionFlowerTrunkFeature;
import net.mcreator.sweetygarden.SnowdropSpruceTreeFeature;
import net.mcreator.sweetygarden.init.SweetyGardenModBlocks;
import net.mcreator.sweetygarden.init.SweetyGardenModFeatures;
import net.mcreator.sweetygarden.init.SweetyGardenModItems;
import net.mcreator.sweetygarden.init.SweetyGardenModParticleTypes;
import net.mcreator.sweetygarden.init.SweetyGardenModTabs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sweety_garden")
public class SweetyGardenMod {
    public static final Logger LOGGER = LogManager.getLogger(SweetyGardenMod.class);
    public static final String MODID = "sweety_garden";
    public static final DeferredRegister<Feature<?>> FEATURE_REGISTRY = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"sweety_garden");
    public static final DeferredHolder<Feature<?>, Feature<NoneFeatureConfiguration>> PASSION_FLOWER_TRUNK_FEATURE = FEATURE_REGISTRY.register("passion_flower_trunk", () -> new PassionFlowerTrunkFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, Feature<NoneFeatureConfiguration>> DRY_BAILEYA_FEATURE = FEATURE_REGISTRY.register("dry_baileya", () -> new DryBaileyaFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, Feature<NoneFeatureConfiguration>> SNOWDROP_SPRUCE_TREE_FEATURE = FEATURE_REGISTRY.register("snowdrop_spruce_tree", () -> new SnowdropSpruceTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public SweetyGardenMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        SweetyGardenModBlocks.REGISTRY.register(modEventBus);
        SweetyGardenModItems.REGISTRY.register(modEventBus);
        SweetyGardenModTabs.REGISTRY.register(modEventBus);
        SweetyGardenModFeatures.REGISTRY.register(modEventBus);
        SweetyGardenModParticleTypes.REGISTRY.register(modEventBus);
        FEATURE_REGISTRY.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            FlowerPotBlock Pot = (FlowerPotBlock)Blocks.FLOWER_POT;
            Pot.addPlant(SweetyGardenModBlocks.HEATHER.getId(), () -> (Block)SweetyGardenModBlocks.POTTED_HEATHER.get());
            Pot.addPlant(SweetyGardenModBlocks.EDELWEISS.getId(), () -> (Block)SweetyGardenModBlocks.POTTED_EDELWEISS.get());
            Pot.addPlant(SweetyGardenModBlocks.PONTEDERIA.getId(), () -> (Block)SweetyGardenModBlocks.POTTED_PONTEDERIA.get());
            Pot.addPlant(SweetyGardenModBlocks.SHAGGY_PURSLANE.getId(), () -> (Block)SweetyGardenModBlocks.POTTED_SHAGGY_PURSLANE.get());
            Pot.addPlant(SweetyGardenModBlocks.BLOODY_DOGWOOD.getId(), () -> (Block)SweetyGardenModBlocks.POTTED_BLOODY_DOGWOOD.get());
            Pot.addPlant(SweetyGardenModBlocks.BUSY_LIZZIE.getId(), () -> (Block)SweetyGardenModBlocks.POTTED_BUSY_LIZZIE.get());
            Pot.addPlant(SweetyGardenModBlocks.SNOWDROP.getId(), () -> (Block)SweetyGardenModBlocks.POTTED_SNOWDROP.get());
            Pot.addPlant(SweetyGardenModBlocks.BAILEYA.getId(), () -> (Block)SweetyGardenModBlocks.POTTED_BAILEYA.get());
            Pot.addPlant(SweetyGardenModBlocks.CYAN_POPPY.getId(), () -> (Block)SweetyGardenModBlocks.POTTED_CYAN_POPPY.get());
        });
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }
}

