/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sweetygarden.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SegmentableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PalePetalsBlock
extends VegetationBlock
implements BonemealableBlock,
SegmentableBlock {
    public static final MapCodec<PalePetalsBlock> CODEC = PalePetalsBlock.simpleCodec(PalePetalsBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty AMOUNT = BlockStateProperties.FLOWER_AMOUNT;
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<PalePetalsBlock> codec() {
        return CODEC;
    }

    public PalePetalsBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.PLANT).sound(SoundType.PINK_PETALS).instabreak().noCollission().pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)AMOUNT, (Comparable)Integer.valueOf(1)));
        this.shapes = this.makeShapes();
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        return this.getShapeForEachState(this.getShapeCalculator(FACING, AMOUNT));
    }

    public Function<BlockState, VoxelShape> getShapeCalculator(EnumProperty<Direction> facingProperty, IntegerProperty amountProperty) {
        return blockState -> {
            Direction direction = (Direction)blockState.getValue((Property)facingProperty);
            Integer amount = (Integer)blockState.getValue((Property)amountProperty);
            VoxelShape[] shapes = new VoxelShape[]{Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)8.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)3.0, (double)8.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)3.0, (double)16.0)};
            VoxelShape shape = Shapes.empty();
            for (int i = 0; i < amount; ++i) {
                int j = Math.floorMod(i - direction.get2DDataValue(), 4);
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)shapes[j]);
            }
            return shape.singleEncompassing();
        };
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return this.canBeReplaced(state, context, AMOUNT) ? true : super.canBeReplaced(state, context);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes.apply(state);
    }

    public double getShapeHeight() {
        return 3.0;
    }

    public IntegerProperty getSegmentAmountProperty() {
        return AMOUNT;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getStateForPlacement(context, (Block)this, AMOUNT, FACING);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AMOUNT});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int currentAmount = (Integer)state.getValue((Property)AMOUNT);
        if (currentAmount < 4) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AMOUNT, (Comparable)Integer.valueOf(currentAmount + 1)), 2);
        } else {
            PalePetalsBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
        }
    }
}

