/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.droptherock.block;

import com.alcatrazescapee.notreepunching.common.blocks.LooseRockBlock;
import com.google.common.base.Supplier;
import fr.samlegamer.droptherock.item.DTRItemRegistry;
import fr.samlegamer.droptherock.rock.DTRRocks;
import fr.samlegamer.droptherock.rock.Rock;
import java.util.ArrayList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DTRBlockRegistry {
    public static final DeferredRegister<Block> BLOCK = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"droptherock");
    public static final RegistryObject<Block> example_stone = DTRBlockRegistry.register("example_stone", (Supplier<? extends Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_))), "droptherock");
    public static final RegistryObject<Block> loose_rock = DTRBlockRegistry.register("vanilla_deepslate_loose_rock", (Supplier<? extends Block>)((Supplier)LooseRockBlock::new), "minecraft");

    public static void createLooseRock() {
        ArrayList<Rock> rocks = new ArrayList<Rock>();
        rocks.addAll(DTRRocks.quark());
        rocks.addAll(DTRRocks.byg());
        rocks.addAll(DTRRocks.bop());
        rocks.addAll(DTRRocks.customRocks());
        for (Rock vanilla : rocks) {
            String modid = vanilla.rock().split(":")[0];
            String name = vanilla.getLooseRock().split(":")[1];
            RegistryObject<Block> registryObject = DTRBlockRegistry.register(name, (Supplier<? extends Block>)((Supplier)LooseRockBlock::new), modid);
        }
    }

    public static void createModdedCobblestone() {
        ArrayList<Rock> rocks = new ArrayList<Rock>();
        rocks.addAll(DTRRocks.quark());
        rocks.addAll(DTRRocks.byg());
        rocks.addAll(DTRRocks.bop());
        rocks.addAll(DTRRocks.customRocks());
        rocks.removeIf(filter -> !filter.cobblestone().contains("droptherock:"));
        for (Rock mod : rocks) {
            String modid = mod.rock().split(":")[0];
            String name = mod.cobblestone().split(":")[1];
            RegistryObject<Block> cobblestone = DTRBlockRegistry.register(name, (Supplier<? extends Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50652_))), modid);
            RegistryObject<Block> cobblestone_slab = DTRBlockRegistry.register(name + "_slab", (Supplier<? extends Block>)((Supplier)() -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50409_))), modid);
            RegistryObject<Block> cobblestone_stairs = DTRBlockRegistry.register(name + "_stairs", (Supplier<? extends Block>)((Supplier)() -> new StairBlock(() -> ((Block)cobblestone.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50157_))), modid);
            RegistryObject<Block> registryObject = DTRBlockRegistry.register(name + "_wall", (Supplier<? extends Block>)((Supplier)() -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50274_))), modid);
        }
    }

    public static RegistryObject<Block> register(String name, Supplier<? extends Block> supplier, String modLoaded) {
        RegistryObject block = BLOCK.register(name, supplier);
        Item.Properties properties = DTRItemRegistry.getPropertiesIsModLoaded(modLoaded);
        DTRItemRegistry.ITEM.register(name, () -> new BlockItem((Block)block.get(), properties));
        return block;
    }
}

