/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.droptherock.client;

import fr.samlegamer.droptherock.block.DTRBlockRegistry;
import fr.samlegamer.droptherock.rock.DTRRocks;
import fr.samlegamer.droptherock.rock.Rock;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class RockBlockstatesProvider
extends BlockStateProvider {
    public RockBlockstatesProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "droptherock", exFileHelper);
    }

    protected void registerStatesAndModels() {
        String exCobble = "droptherock_example_cobblestone";
        this.simpleBlock((Block)DTRBlockRegistry.example_stone.get(), (ModelFile)this.models().cubeAll("example_stone", new ResourceLocation("droptherock", "block/example_stone")));
        this.simpleBlock((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("droptherock", exCobble)), (ModelFile)this.models().cubeAll(exCobble, new ResourceLocation("droptherock", "block/" + exCobble)));
        this.slabBlock((SlabBlock)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("droptherock", exCobble + "_slab")), new ResourceLocation("droptherock", "block/" + exCobble), new ResourceLocation("droptherock", "block/" + exCobble));
        this.stairsBlock((StairBlock)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("droptherock", exCobble + "_stairs")), new ResourceLocation("droptherock", "block/" + exCobble));
        this.wallBlock((WallBlock)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("droptherock", exCobble + "_wall")), new ResourceLocation("droptherock", "block/" + exCobble));
        ((BlockModelBuilder)this.models().withExistingParent(exCobble + "_wall_inventory", this.mcLoc("block/wall_inventory"))).texture("wall", new ResourceLocation("droptherock", "block/" + exCobble));
        HashSet<Block> done = new HashSet<Block>();
        ArrayList<Rock> cobblestones = new ArrayList<Rock>();
        cobblestones.addAll(DTRRocks.quark());
        cobblestones.addAll(DTRRocks.byg());
        cobblestones.addAll(DTRRocks.bop());
        cobblestones.removeIf(filter -> !filter.cobblestone().contains("droptherock:"));
        for (Rock rock : cobblestones) {
            String modid = rock.cobblestone().split(":")[0];
            String name = rock.cobblestone().split(":")[1];
            Block cobblestone = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("droptherock", name));
            SlabBlock cobblestone_slab = (SlabBlock)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("droptherock", name + "_slab"));
            StairBlock cobblestone_stairs = (StairBlock)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("droptherock", name + "_stairs"));
            WallBlock cobblestone_wall = (WallBlock)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("droptherock", name + "_wall"));
            if (cobblestone == null || cobblestone_slab == null || cobblestone_stairs == null || cobblestone_wall == null || !done.add(cobblestone)) continue;
            this.simpleBlock(cobblestone, (ModelFile)this.models().cubeAll(name, new ResourceLocation(modid, "block/" + name)));
            this.slabBlock(cobblestone_slab, new ResourceLocation(modid, "block/" + name), new ResourceLocation(modid, "block/" + name));
            this.stairsBlock(cobblestone_stairs, new ResourceLocation(modid, "block/" + name));
            this.wallBlock(cobblestone_wall, new ResourceLocation(modid, "block/" + name));
            ((BlockModelBuilder)this.models().withExistingParent(name + "_wall_inventory", this.mcLoc("block/wall_inventory"))).texture("wall", new ResourceLocation(modid, "block/" + name));
        }
    }
}

