/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.droptherock.config;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import fr.samlegamer.droptherock.DropTheRock;
import fr.samlegamer.droptherock.rock.Rock;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public class DTRRockableAdd {
    public static void initOrCreateCfg() {
        if (!FMLPaths.CONFIGDIR.get().resolve("droptherockadd.json").toFile().exists()) {
            try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(FMLPaths.CONFIGDIR.get().resolve("droptherockadd.json").toFile()));){
                writer.setIndent("  ");
                writer.beginArray();
                writer.beginObject();
                writer.name("base_block").value("droptherock:example_stone");
                writer.name("loose_rock_block").value("droptherock:droptherock_example_stone_loose_rock");
                writer.name("cobblestone_block").value("droptherock:droptherock_example_cobblestone");
                writer.endObject();
                writer.endArray();
            }
            catch (Exception e) {
                DropTheRock.LOGGER.info("Could not create default config file droptherockadd.json");
            }
        }
        if (!FMLPaths.CONFIGDIR.get().resolve("dropthemat" + File.separator).toFile().exists()) {
            FMLPaths.CONFIGDIR.get().resolve("dropthemat" + File.separator).toFile().mkdir();
        }
    }

    public static List<Rock> getRockLooseAndCobble() {
        ArrayList<Rock> list = new ArrayList<Rock>();
        if (FMLPaths.CONFIGDIR.get().resolve("droptherockadd.json").toFile().exists()) {
            try (JsonReader reader = new JsonReader((Reader)new FileReader(FMLPaths.CONFIGDIR.get().resolve("droptherockadd.json").toFile()));){
                reader.beginArray();
                while (reader.hasNext()) {
                    reader.beginObject();
                    String base = "";
                    String loose = "";
                    String cobble = "";
                    block18: while (reader.hasNext()) {
                        String name;
                        switch (name = reader.nextName()) {
                            case "base_block": {
                                base = reader.nextString();
                                continue block18;
                            }
                            case "loose_rock_block": {
                                loose = reader.nextString();
                                continue block18;
                            }
                            case "cobblestone_block": {
                                cobble = reader.nextString();
                                continue block18;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    if (!(base.isEmpty() || loose.isEmpty() || cobble.isEmpty())) {
                        Rock rock = new Rock(base, loose, cobble);
                        if (list.contains(rock)) continue;
                        list.add(rock);
                        continue;
                    }
                    DropTheRock.LOGGER.info("Error with custom rock: {} -> {} -> {}", (Object)base, (Object)loose, (Object)cobble);
                }
                reader.endArray();
            }
            catch (Exception e) {
                DropTheRock.LOGGER.info("Could not read default config file droptherockadd.json");
            }
        }
        return list;
    }
}

