/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.droptherock.loot;

import fr.samlegamer.droptherock.config.DTRConfig;
import fr.samlegamer.droptherock.enchant.DTREnchantmentRegistry;
import fr.samlegamer.droptherock.rock.DTRRocks;
import fr.samlegamer.droptherock.rock.Rock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class RocksLootModifier
extends LootModifier {
    protected RocksLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public LootItemCondition[] conditions() {
        return this.conditions;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        boolean hasSilkTouch = tool != null && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0;
        boolean hasLithofusion = tool != null && EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DTREnchantmentRegistry.LITHOFUSION.get()), (ItemStack)tool) > 0;
        ArrayList<Rock> rocks = new ArrayList<Rock>();
        if (((Boolean)DTRConfig.enableVanillaRocks.get()).booleanValue()) {
            rocks.addAll(DTRRocks.vanilla());
        }
        if (ModList.get().isLoaded("quark") && ((Boolean)DTRConfig.enableQuarkRocks.get()).booleanValue()) {
            rocks.addAll(DTRRocks.quark());
        }
        if (ModList.get().isLoaded("byg") && ((Boolean)DTRConfig.enableBYGRocks.get()).booleanValue()) {
            rocks.addAll(DTRRocks.byg());
        }
        if (ModList.get().isLoaded("biomesoplenty") && ((Boolean)DTRConfig.enableBOPRocks.get()).booleanValue()) {
            rocks.addAll(DTRRocks.bop());
        }
        rocks.addAll(DTRRocks.customRocks());
        for (Rock vanillaRockable : rocks) {
            Block rock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(vanillaRockable.rock()));
            Item loose_rock = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(vanillaRockable.getLooseRock()));
            Block cobblestone = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(vanillaRockable.cobblestone()));
            String modid = vanillaRockable.rock().split(":")[0];
            if (cobblestone == null || rock == null || loose_rock == null || !ModList.get().isLoaded(modid) || state == null || !state.m_60713_(rock)) continue;
            generatedLoot.clear();
            if (hasSilkTouch) {
                generatedLoot.add(new ItemStack((ItemLike)rock, 1));
                continue;
            }
            if (hasLithofusion) {
                generatedLoot.add(new ItemStack((ItemLike)cobblestone, 1));
                continue;
            }
            int fortuneLevel = tool != null ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool) : 0;
            Random rand = new Random();
            int amount = rand.nextInt(4) + 1 + rand.nextInt(fortuneLevel + 1);
            generatedLoot.add(new ItemStack((ItemLike)loose_rock, amount));
        }
        return generatedLoot;
    }
}

