/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.droptherock.block;

import com.alcatrazescapee.notreepunching.common.blocks.LooseRockBlock;
import com.google.common.base.Supplier;
import fr.samlegamer.droptherock.item.DTRItemRegistry;
import fr.samlegamer.droptherock.rock.DTRRocks;
import fr.samlegamer.droptherock.rock.Rock;
import java.util.ArrayList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class DTRBlockRegistry {
    public static final DeferredRegister<Block> BLOCK = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"droptherock");
    public static final RegistryObject<Block> example_stone = DTRBlockRegistry.register("example_stone", (Supplier<? extends Block>)((Supplier)() -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150348_b))), "droptherock");

    public static void createLooseRock() {
        ArrayList<Rock> rocks = new ArrayList<Rock>();
        rocks.addAll(DTRRocks.quark());
        rocks.addAll(DTRRocks.byg());
        rocks.addAll(DTRRocks.bop());
        rocks.addAll(DTRRocks.customRocks());
        for (Rock vanilla : rocks) {
            String modid = vanilla.getRock().split(":")[0];
            String name = vanilla.getLooseRock().split(":")[1];
            RegistryObject<Block> registryObject = DTRBlockRegistry.register(name, (Supplier<? extends Block>)((Supplier)LooseRockBlock::new), modid);
        }
    }

    public static void createModdedCobblestone() {
        ArrayList<Rock> rocks = new ArrayList<Rock>();
        rocks.addAll(DTRRocks.quark());
        rocks.addAll(DTRRocks.byg());
        rocks.addAll(DTRRocks.bop());
        rocks.addAll(DTRRocks.customRocks());
        rocks.removeIf(filter -> !filter.getCobblestone().contains("droptherock:"));
        for (Rock mod : rocks) {
            String modid = mod.getRock().split(":")[0];
            String name = mod.getCobblestone().split(":")[1];
            RegistryObject<Block> cobblestone = DTRBlockRegistry.register(name, (Supplier<? extends Block>)((Supplier)() -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150347_e))), modid);
            RegistryObject<Block> cobblestone_slab = DTRBlockRegistry.register(name + "_slab", (Supplier<? extends Block>)((Supplier)() -> new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196646_bz))), modid);
            RegistryObject<Block> cobblestone_stairs = DTRBlockRegistry.register(name + "_stairs", (Supplier<? extends Block>)((Supplier)() -> new StairsBlock(() -> ((Block)cobblestone.get()).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196659_cl))), modid);
            RegistryObject<Block> registryObject = DTRBlockRegistry.register(name + "_wall", (Supplier<? extends Block>)((Supplier)() -> new WallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150463_bK))), modid);
        }
    }

    public static RegistryObject<Block> register(String name, Supplier<? extends Block> supplier, String modLoaded) {
        RegistryObject block = BLOCK.register(name, supplier);
        Item.Properties properties = DTRItemRegistry.getPropertiesIsModLoaded(modLoaded);
        DTRItemRegistry.ITEM.register(name, () -> new BlockItem((Block)block.get(), properties));
        return block;
    }
}

