/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.droptherock.client;

import fr.samlegamer.droptherock.rock.DTRRocks;
import fr.samlegamer.droptherock.rock.Rock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class RockItemsModelsProvider
extends ItemModelProvider {
    public RockItemsModelsProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "droptherock", existingFileHelper);
    }

    protected void registerModels() {
        String exCobble = "droptherock_example_cobblestone";
        String ex = "example_stone";
        this.withExistingParent(ex, new ResourceLocation(this.modid, "block/" + ex));
        this.withExistingParent(exCobble, new ResourceLocation(this.modid, "block/" + exCobble));
        this.withExistingParent(exCobble + "_slab", new ResourceLocation(this.modid, "block/" + exCobble + "_slab"));
        this.withExistingParent(exCobble + "_stairs", new ResourceLocation(this.modid, "block/" + exCobble + "_stairs"));
        this.withExistingParent(exCobble + "_wall", new ResourceLocation(this.modid, "block/" + exCobble + "_wall_inventory"));
        ArrayList<Rock> rocks = new ArrayList<Rock>();
        rocks.addAll(DTRRocks.quark());
        rocks.addAll(DTRRocks.byg());
        rocks.addAll(DTRRocks.bop());
        rocks.addAll(DTRRocks.customRocks());
        for (Rock rock : rocks) {
            String[] parts = rock.getLooseRock().split(":");
            String modid = parts[0];
            String name = parts[1];
            ((ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", new ResourceLocation(modid, "item/" + name));
        }
        ArrayList<Rock> cobble = new ArrayList<Rock>();
        cobble.addAll(DTRRocks.quark());
        cobble.addAll(DTRRocks.byg());
        cobble.addAll(DTRRocks.bop());
        cobble.removeIf(filter -> !filter.getCobblestone().contains("droptherock:"));
        for (Rock rock : cobble) {
            String[] parts = rock.getCobblestone().split(":");
            String modid = parts[0];
            String name = parts[1];
            this.withExistingParent(name, new ResourceLocation(modid, "block/" + name));
            this.withExistingParent(name + "_stairs", new ResourceLocation(modid, "block/" + name + "_stairs"));
            this.withExistingParent(name + "_slab", new ResourceLocation(modid, "block/" + name + "_slab"));
            this.withExistingParent(name + "_wall", new ResourceLocation(modid, "block/" + name + "_wall_inventory"));
        }
        List<String> list = Arrays.asList("iaf_copper_", "iaf_silver_", "iaf_dragonbone_");
        for (String mat : list) {
            ((ItemModelBuilder)this.withExistingParent(mat + "knife", this.mcLoc("item/handheld"))).texture("layer0", new ResourceLocation("droptherock", "item/" + mat + "knife"));
            ((ItemModelBuilder)this.withExistingParent(mat + "saw", this.mcLoc("item/handheld"))).texture("layer0", new ResourceLocation("droptherock", "item/" + mat + "saw"));
            ((ItemModelBuilder)this.withExistingParent(mat + "mattock", this.mcLoc("item/handheld"))).texture("layer0", new ResourceLocation("droptherock", "item/" + mat + "mattock"));
        }
    }
}

