/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.droptherock.item;

import com.alcatrazescapee.notreepunching.common.ModItemGroup;
import com.alcatrazescapee.notreepunching.common.items.KnifeItem;
import com.alcatrazescapee.notreepunching.common.items.MattockItem;
import com.google.gson.stream.JsonReader;
import fr.samlegamer.droptherock.DropTheRock;
import fr.samlegamer.droptherock.item.MaterialTiers;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Objects;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class DTRItemRegistry {
    public static final DeferredRegister<Item> ITEM = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"droptherock");
    public static final MaterialTiers SILVER_TOOL_MATERIAL = new MaterialTiers(2, 460, 11.0f, 1.0f, 18, (LazyValue<Ingredient>)new LazyValue(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("iceandfire", "silver_ingot"))})));
    public static final MaterialTiers COPPER_TOOL_MATERIAL = new MaterialTiers(2, 300, 0.7f, 0.0f, 10, (LazyValue<Ingredient>)new LazyValue(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("iceandfire", "copper_ingot"))})));
    public static final MaterialTiers DRAGONBONE_TOOL_MATERIAL = new MaterialTiers(4, 1660, 10.0f, 4.0f, 22, (LazyValue<Ingredient>)new LazyValue(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("iceandfire", "dragonbone"))})));
    public static final RegistryObject<Item> IAF_COPPER_KNIFE = ITEM.register("iaf_copper_knife", () -> new KnifeItem((IItemTier)COPPER_TOOL_MATERIAL, 1, -2.2f, DTRItemRegistry.getPropertiesIsModLoaded("iceandfire")));
    public static final RegistryObject<Item> IAF_SILVER_KNIFE = ITEM.register("iaf_silver_knife", () -> new KnifeItem((IItemTier)SILVER_TOOL_MATERIAL, 1, -2.2f, DTRItemRegistry.getPropertiesIsModLoaded("iceandfire")));
    public static final RegistryObject<Item> IAF_DRAGONBONE_KNIFE = ITEM.register("iaf_dragonbone_knife", () -> new KnifeItem((IItemTier)DRAGONBONE_TOOL_MATERIAL, 1, -2.2f, DTRItemRegistry.getPropertiesIsModLoaded("iceandfire")));
    public static final RegistryObject<Item> IAF_COPPER_SAW = ITEM.register("iaf_copper_saw", () -> new AxeItem((IItemTier)COPPER_TOOL_MATERIAL, 2.0f, -3.2f, DTRItemRegistry.getPropertiesIsModLoaded("iceandfire")));
    public static final RegistryObject<Item> IAF_SILVER_SAW = ITEM.register("iaf_silver_saw", () -> new AxeItem((IItemTier)SILVER_TOOL_MATERIAL, 2.0f, -3.2f, DTRItemRegistry.getPropertiesIsModLoaded("iceandfire")));
    public static final RegistryObject<Item> IAF_DRAGONBONE_SAW = ITEM.register("iaf_dragonbone_saw", () -> new AxeItem((IItemTier)DRAGONBONE_TOOL_MATERIAL, 2.0f, -3.2f, DTRItemRegistry.getPropertiesIsModLoaded("iceandfire")));
    public static final RegistryObject<Item> IAF_COPPER_MATTOCK = ITEM.register("iaf_copper_mattock", () -> new MattockItem((IItemTier)COPPER_TOOL_MATERIAL, 0.5f, -3.0f, DTRItemRegistry.getPropertiesIsModLoaded("iceandfire")));
    public static final RegistryObject<Item> IAF_SILVER_MATTOCK = ITEM.register("iaf_silver_mattock", () -> new MattockItem((IItemTier)SILVER_TOOL_MATERIAL, 0.5f, -3.0f, DTRItemRegistry.getPropertiesIsModLoaded("iceandfire")));
    public static final RegistryObject<Item> IAF_DRAGONBONE_MATTOCK = ITEM.register("iaf_dragonbone_mattock", () -> new MattockItem((IItemTier)DRAGONBONE_TOOL_MATERIAL, 0.5f, -3.0f, DTRItemRegistry.getPropertiesIsModLoaded("iceandfire")));

    public static void registerCustom() {
        for (File file : Objects.requireNonNull(FMLPaths.CONFIGDIR.get().resolve("dropthemat" + File.separator).toFile().listFiles())) {
            try (JsonReader reader = new JsonReader((Reader)new FileReader(file));){
                reader.beginObject();
                String repair = "";
                int level = 0;
                int durability = 0;
                float efficiency = 0.0f;
                float attack = 0.0f;
                int enchant = 0;
                block28: while (reader.hasNext()) {
                    String name;
                    switch (name = reader.nextName()) {
                        case "RepairIngredient": {
                            repair = reader.nextString();
                            continue block28;
                        }
                        case "Level": {
                            level = reader.nextInt();
                            continue block28;
                        }
                        case "Durability": {
                            durability = reader.nextInt();
                            continue block28;
                        }
                        case "Efficiency": {
                            efficiency = (float)reader.nextDouble();
                            continue block28;
                        }
                        case "AttackDamage": {
                            attack = (float)reader.nextDouble();
                            continue block28;
                        }
                        case "EnchantmentValue": {
                            enchant = reader.nextInt();
                            continue block28;
                        }
                    }
                    reader.skipValue();
                }
                reader.endObject();
                String finalRepair = repair;
                MaterialTiers mat = new MaterialTiers(level, durability, efficiency, attack, enchant, (LazyValue<Ingredient>)new LazyValue(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(finalRepair))})));
                String name = file.getName().replace(".json", "");
                ITEM.register(name + "_knife", () -> new KnifeItem((IItemTier)mat, 1, -2.2f, new Item.Properties().func_200916_a(ModItemGroup.ITEMS)));
                ITEM.register(name + "_saw", () -> new AxeItem((IItemTier)mat, 2.0f, -3.2f, new Item.Properties().func_200916_a(ModItemGroup.ITEMS)));
                ITEM.register(name + "_mattock", () -> new MattockItem((IItemTier)mat, 0.5f, -3.0f, new Item.Properties().func_200916_a(ModItemGroup.ITEMS)));
            }
            catch (Exception e) {
                DropTheRock.LOGGER.error("Error while loading custom item from {}", (Object)file.getName(), (Object)e);
            }
        }
    }

    public static Item.Properties getPropertiesIsModLoaded(String modid) {
        Item.Properties properties = new Item.Properties();
        if (ModList.get().isLoaded(modid)) {
            properties.func_200916_a(ModItemGroup.ITEMS);
        }
        return properties;
    }
}

