/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.droptherock.loot;

import fr.samlegamer.droptherock.config.DTRConfig;
import fr.samlegamer.droptherock.enchant.DTREnchantmentRegistry;
import fr.samlegamer.droptherock.rock.DTRRocks;
import fr.samlegamer.droptherock.rock.Rock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class RocksLootModifier
extends LootModifier {
    protected RocksLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public ILootCondition[] conditions() {
        return this.conditions;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        boolean hasSilkTouch = tool != null && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool) > 0;
        boolean hasLithofusion = tool != null && EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)DTREnchantmentRegistry.LITHOFUSION.get()), (ItemStack)tool) > 0;
        ArrayList<Rock> rocks = new ArrayList<Rock>();
        if (((Boolean)DTRConfig.enableVanillaRocks.get()).booleanValue()) {
            rocks.addAll(DTRRocks.vanilla());
        }
        if (ModList.get().isLoaded("quark") && ((Boolean)DTRConfig.enableQuarkRocks.get()).booleanValue()) {
            rocks.addAll(DTRRocks.quark());
        }
        if (ModList.get().isLoaded("byg") && ((Boolean)DTRConfig.enableBYGRocks.get()).booleanValue()) {
            rocks.addAll(DTRRocks.byg());
        }
        if (ModList.get().isLoaded("biomesoplenty") && ((Boolean)DTRConfig.enableBOPRocks.get()).booleanValue()) {
            rocks.addAll(DTRRocks.bop());
        }
        rocks.addAll(DTRRocks.customRocks());
        for (Rock vanillaRockable : rocks) {
            Block rock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(vanillaRockable.getRock()));
            Item loose_rock = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(vanillaRockable.getLooseRock()));
            Block cobblestone = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(vanillaRockable.getCobblestone()));
            String modid = vanillaRockable.getRock().split(":")[0];
            if (cobblestone == null || rock == null || loose_rock == null || !ModList.get().isLoaded(modid) || state == null || !state.func_203425_a(rock)) continue;
            generatedLoot.clear();
            if (hasSilkTouch) {
                generatedLoot.add(new ItemStack((IItemProvider)rock, 1));
                continue;
            }
            if (hasLithofusion) {
                generatedLoot.add(new ItemStack((IItemProvider)cobblestone, 1));
                continue;
            }
            int fortuneLevel = tool != null ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool) : 0;
            Random rand = new Random();
            int amount = rand.nextInt(4) + 1 + rand.nextInt(fortuneLevel + 1);
            generatedLoot.add(new ItemStack((IItemProvider)loose_rock, amount));
        }
        return generatedLoot;
    }
}

