/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.droptherock;

import com.alcatrazescapee.notreepunching.common.items.ModItemGroups;
import fr.samlegamer.droptherock.DTREvents;
import fr.samlegamer.droptherock.block.DTRBlockRegistry;
import fr.samlegamer.droptherock.client.RockBlockstatesProvider;
import fr.samlegamer.droptherock.client.RockItemsModelsProvider;
import fr.samlegamer.droptherock.config.DTRConfig;
import fr.samlegamer.droptherock.config.DTRRockableAdd;
import fr.samlegamer.droptherock.data.RockBlocksTagsProvider;
import fr.samlegamer.droptherock.data.RockItemsTagsProvider;
import fr.samlegamer.droptherock.data.RockRecipesProvider;
import fr.samlegamer.droptherock.enchant.DTREnchantmentRegistry;
import fr.samlegamer.droptherock.item.DTRItemRegistry;
import fr.samlegamer.droptherock.loot.LootModRegistry;
import fr.samlegamer.droptherock.mapping.MissingnoFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="droptherock")
public class DropTheRock {
    public static final String MODID = "droptherock";
    public static final Logger LOGGER = LogManager.getLogger((String)"droptherock");

    public DropTheRock(FMLJavaModLoadingContext javaModLoadingContext) {
        LOGGER.info("Loading DropTheRock");
        javaModLoadingContext.getModEventBus().addListener(this::setup);
        javaModLoadingContext.getModEventBus().addListener(this::onGatherData);
        javaModLoadingContext.getModEventBus().addListener(this::addOnTab);
        javaModLoadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DTRConfig.CONFIG_SPEC);
        DTRRockableAdd.initOrCreateCfg();
        IEventBus bus = javaModLoadingContext.getModEventBus();
        DTRItemRegistry.ITEM.register(bus);
        DTRBlockRegistry.BLOCK.register(bus);
        DTREnchantmentRegistry.ENCHANTMENT.register(bus);
        LootModRegistry.SERIALIZERS.register(bus);
        DTRBlockRegistry.createModdedCobblestone();
        DTRItemRegistry.registerCustom();
        MinecraftForge.EVENT_BUS.register(MissingnoFix.class);
        LOGGER.info("Finished Loading DropTheRock");
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture completableFuture = event.getLookupProvider();
        PackOutput packOutput = generator.getPackOutput();
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new RockBlockstatesProvider(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new RockItemsModelsProvider(packOutput, existingFileHelper));
        }
        if (event.includeServer()) {
            RockBlocksTagsProvider blocksTagsProvider = (RockBlocksTagsProvider)generator.addProvider(true, (DataProvider)new RockBlocksTagsProvider(packOutput, completableFuture, existingFileHelper));
            generator.addProvider(true, (DataProvider)new RockRecipesProvider(packOutput));
            generator.addProvider(true, (DataProvider)new RockItemsTagsProvider(packOutput, completableFuture, blocksTagsProvider.m_274426_(), existingFileHelper));
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(DTREvents.class);
    }

    private void addOnTab(BuildCreativeModeTabContentsEvent event) {
        ModList modList = ModList.get();
        if (event.getTab() == ModItemGroups.TAB.get()) {
            event.m_246326_((ItemLike)DTRBlockRegistry.vanilla_deepslate_loose_rock.get());
            if (modList.isLoaded("iceandfire")) {
                event.m_246601_(this.searcher("iaf"));
            }
            if (modList.isLoaded("quark")) {
                event.m_246601_(this.searcher("quark"));
            }
            if (modList.isLoaded("biomeswevegone")) {
                event.m_246601_(this.searcher("biomeswevegone"));
            }
            if (modList.isLoaded("biomesoplenty")) {
                event.m_246601_(this.searcher("biomesoplenty"));
            }
            event.m_246326_((ItemLike)DTRBlockRegistry.example_stone.get());
            event.m_246601_(this.searcher("droptherock_example_"));
        }
    }

    private Collection<ItemStack> searcher(String contains) {
        Collection items = DTRItemRegistry.ITEM.getEntries();
        HashSet<ItemStack> item_accepted = new HashSet<ItemStack>();
        for (RegistryObject item : items) {
            if (item.getId() == null || !item.getId().m_135815_().contains(contains)) continue;
            item_accepted.add(((Item)item.get()).m_7968_());
        }
        ArrayList<ItemStack> sortedList = new ArrayList<ItemStack>(item_accepted);
        sortedList.sort(Comparator.comparing(stack -> stack.m_41720_().m_5524_()));
        return sortedList;
    }
}

