/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.droptherock.client;

import fr.samlegamer.droptherock.block.DTRBlockRegistry;
import fr.samlegamer.droptherock.rock.DTRRocks;
import fr.samlegamer.droptherock.rock.Rock;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class RockBlockstatesProvider
extends BlockStateProvider {
    public RockBlockstatesProvider(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "droptherock", exFileHelper);
    }

    protected void registerStatesAndModels() {
        String exCobble = "droptherock_example_cobblestone";
        this.simpleBlock((Block)DTRBlockRegistry.example_stone.get(), (ModelFile)this.models().cubeAll("example_stone", ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)"block/example_stone")));
        this.simpleBlock((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)exCobble)), (ModelFile)this.models().cubeAll(exCobble, ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)("block/" + exCobble))));
        this.slabBlock((SlabBlock)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)(exCobble + "_slab"))), ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)("block/" + exCobble)), ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)("block/" + exCobble)));
        this.stairsBlock((StairBlock)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)(exCobble + "_stairs"))), ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)("block/" + exCobble)));
        this.wallBlock((WallBlock)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)(exCobble + "_wall"))), ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)("block/" + exCobble)));
        ((BlockModelBuilder)this.models().withExistingParent(exCobble + "_wall_inventory", this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)("block/" + exCobble)));
        HashSet<Block> done = new HashSet<Block>();
        ArrayList<Rock> cobblestones = new ArrayList<Rock>();
        cobblestones.addAll(DTRRocks.quark());
        cobblestones.addAll(DTRRocks.biomeswevegone());
        cobblestones.addAll(DTRRocks.bop());
        cobblestones.removeIf(filter -> !filter.cobblestone().contains("droptherock:"));
        for (Rock rock : cobblestones) {
            String modid = rock.cobblestone().split(":")[0];
            String name = rock.cobblestone().split(":")[1];
            Block cobblestone = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)name));
            SlabBlock cobblestone_slab = (SlabBlock)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)(name + "_slab")));
            StairBlock cobblestone_stairs = (StairBlock)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)(name + "_stairs")));
            WallBlock cobblestone_wall = (WallBlock)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)(name + "_wall")));
            if (cobblestone == null || cobblestone_slab == null || cobblestone_stairs == null || cobblestone_wall == null || !done.add(cobblestone)) continue;
            this.simpleBlock(cobblestone, (ModelFile)this.models().cubeAll(name, ResourceLocation.fromNamespaceAndPath((String)modid, (String)("block/" + name))));
            this.slabBlock(cobblestone_slab, ResourceLocation.fromNamespaceAndPath((String)modid, (String)("block/" + name)), ResourceLocation.fromNamespaceAndPath((String)modid, (String)("block/" + name)));
            this.stairsBlock(cobblestone_stairs, ResourceLocation.fromNamespaceAndPath((String)modid, (String)("block/" + name)));
            this.wallBlock(cobblestone_wall, ResourceLocation.fromNamespaceAndPath((String)modid, (String)("block/" + name)));
            ((BlockModelBuilder)this.models().withExistingParent(name + "_wall_inventory", this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)modid, (String)("block/" + name)));
        }
    }
}

