/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.droptherock.client;

import fr.samlegamer.droptherock.rock.DTRRocks;
import fr.samlegamer.droptherock.rock.Rock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class RockItemsModelsProvider
extends ItemModelProvider {
    public RockItemsModelsProvider(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "droptherock", existingFileHelper);
    }

    protected void registerModels() {
        String exCobble = "droptherock_example_cobblestone";
        String ex = "example_stone";
        this.withExistingParent(ex, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)("block/" + ex)));
        this.withExistingParent(exCobble, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)("block/" + exCobble)));
        this.withExistingParent(exCobble + "_slab", ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)("block/" + exCobble + "_slab")));
        this.withExistingParent(exCobble + "_stairs", ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)("block/" + exCobble + "_stairs")));
        this.withExistingParent(exCobble + "_wall", ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)("block/" + exCobble + "_wall_inventory")));
        ArrayList<Rock> rocks = new ArrayList<Rock>();
        rocks.addAll(DTRRocks.quark());
        rocks.addAll(DTRRocks.biomeswevegone());
        rocks.addAll(DTRRocks.bop());
        rocks.addAll(DTRRocks.customRocks());
        rocks.add(new Rock("minecraft:deepslate", "droptherock:vanilla_deepslate_loose_rock", "minecraft:cobbled_deepslate"));
        for (Rock rock : rocks) {
            String[] parts = rock.getLooseRock().split(":");
            String modid = parts[0];
            String name = parts[1];
            ((ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)modid, (String)("item/" + name)));
        }
        ArrayList<Rock> cobble = new ArrayList<Rock>();
        cobble.addAll(DTRRocks.quark());
        cobble.addAll(DTRRocks.biomeswevegone());
        cobble.addAll(DTRRocks.bop());
        cobble.removeIf(filter -> !filter.cobblestone().contains("droptherock:"));
        for (Rock rock : cobble) {
            String[] parts = rock.cobblestone().split(":");
            String modid = parts[0];
            String name = parts[1];
            this.withExistingParent(name, ResourceLocation.fromNamespaceAndPath((String)modid, (String)("block/" + name)));
            this.withExistingParent(name + "_stairs", ResourceLocation.fromNamespaceAndPath((String)modid, (String)("block/" + name + "_stairs")));
            this.withExistingParent(name + "_slab", ResourceLocation.fromNamespaceAndPath((String)modid, (String)("block/" + name + "_slab")));
            this.withExistingParent(name + "_wall", ResourceLocation.fromNamespaceAndPath((String)modid, (String)("block/" + name + "_wall_inventory")));
        }
        List<String> list = Arrays.asList("iaf_copper_", "iaf_silver_", "iaf_dragonbone_");
        for (String mat : list) {
            ((ItemModelBuilder)this.withExistingParent(mat + "knife", this.mcLoc("item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)("item/" + mat + "knife")));
            ((ItemModelBuilder)this.withExistingParent(mat + "saw", this.mcLoc("item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)("item/" + mat + "saw")));
            ((ItemModelBuilder)this.withExistingParent(mat + "mattock", this.mcLoc("item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"droptherock", (String)("item/" + mat + "mattock")));
        }
    }
}

