/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.droptherock.item;

import com.alcatrazescapee.notreepunching.common.items.KnifeItem;
import com.alcatrazescapee.notreepunching.common.items.MattockItem;
import com.google.gson.stream.JsonReader;
import fr.samlegamer.droptherock.DropTheRock;
import fr.samlegamer.droptherock.item.MaterialTiers;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DTRItemRegistry {
    public static final DeferredRegister<Item> ITEM = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"droptherock");
    public static final MaterialTiers SILVER_TOOL_MATERIAL = new MaterialTiers(2, 460, 11.0f, 1.0f, 18, (LazyLoadedValue<Ingredient>)new LazyLoadedValue(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"silver_ingot"))})));
    public static final MaterialTiers COPPER_TOOL_MATERIAL = new MaterialTiers(2, 300, 0.7f, 0.0f, 10, (LazyLoadedValue<Ingredient>)new LazyLoadedValue(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"copper_ingot"))})));
    public static final MaterialTiers DRAGONBONE_TOOL_MATERIAL = new MaterialTiers(4, 1660, 10.0f, 4.0f, 22, (LazyLoadedValue<Ingredient>)new LazyLoadedValue(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dragonbone"))})));
    public static final RegistryObject<Item> IAF_COPPER_KNIFE = ITEM.register("iaf_copper_knife", () -> new KnifeItem((Tier)COPPER_TOOL_MATERIAL, 1, -2.2f, DTRItemRegistry.getPropertiesIsModLoaded()));
    public static final RegistryObject<Item> IAF_SILVER_KNIFE = ITEM.register("iaf_silver_knife", () -> new KnifeItem((Tier)SILVER_TOOL_MATERIAL, 1, -2.2f, DTRItemRegistry.getPropertiesIsModLoaded()));
    public static final RegistryObject<Item> IAF_DRAGONBONE_KNIFE = ITEM.register("iaf_dragonbone_knife", () -> new KnifeItem((Tier)DRAGONBONE_TOOL_MATERIAL, 1, -2.2f, DTRItemRegistry.getPropertiesIsModLoaded()));
    public static final RegistryObject<Item> IAF_COPPER_SAW = ITEM.register("iaf_copper_saw", () -> new AxeItem((Tier)COPPER_TOOL_MATERIAL, 2.0f, -3.2f, DTRItemRegistry.getPropertiesIsModLoaded()));
    public static final RegistryObject<Item> IAF_SILVER_SAW = ITEM.register("iaf_silver_saw", () -> new AxeItem((Tier)SILVER_TOOL_MATERIAL, 2.0f, -3.2f, DTRItemRegistry.getPropertiesIsModLoaded()));
    public static final RegistryObject<Item> IAF_DRAGONBONE_SAW = ITEM.register("iaf_dragonbone_saw", () -> new AxeItem((Tier)DRAGONBONE_TOOL_MATERIAL, 2.0f, -3.2f, DTRItemRegistry.getPropertiesIsModLoaded()));
    public static final RegistryObject<Item> IAF_COPPER_MATTOCK = ITEM.register("iaf_copper_mattock", () -> new MattockItem((Tier)COPPER_TOOL_MATERIAL, 0.5f, -3.0f, DTRItemRegistry.getPropertiesIsModLoaded()));
    public static final RegistryObject<Item> IAF_SILVER_MATTOCK = ITEM.register("iaf_silver_mattock", () -> new MattockItem((Tier)SILVER_TOOL_MATERIAL, 0.5f, -3.0f, DTRItemRegistry.getPropertiesIsModLoaded()));
    public static final RegistryObject<Item> IAF_DRAGONBONE_MATTOCK = ITEM.register("iaf_dragonbone_mattock", () -> new MattockItem((Tier)DRAGONBONE_TOOL_MATERIAL, 0.5f, -3.0f, DTRItemRegistry.getPropertiesIsModLoaded()));

    public static void registerCustom() {
        for (File file : Objects.requireNonNull(FMLPaths.CONFIGDIR.get().resolve("dropthemat" + File.separator).toFile().listFiles())) {
            try (JsonReader reader = new JsonReader((Reader)new FileReader(file));){
                reader.beginObject();
                String repair = "";
                int level = 0;
                int durability = 0;
                float efficiency = 0.0f;
                float attack = 0.0f;
                int enchant = 0;
                block24: while (reader.hasNext()) {
                    String name;
                    switch (name = reader.nextName()) {
                        case "RepairIngredient": {
                            repair = reader.nextString();
                            continue block24;
                        }
                        case "Level": {
                            level = reader.nextInt();
                            continue block24;
                        }
                        case "Durability": {
                            durability = reader.nextInt();
                            continue block24;
                        }
                        case "Efficiency": {
                            efficiency = (float)reader.nextDouble();
                            continue block24;
                        }
                        case "AttackDamage": {
                            attack = (float)reader.nextDouble();
                            continue block24;
                        }
                        case "EnchantmentValue": {
                            enchant = reader.nextInt();
                            continue block24;
                        }
                    }
                    reader.skipValue();
                }
                reader.endObject();
                String finalRepair = repair;
                MaterialTiers mat = new MaterialTiers(level, durability, efficiency, attack, enchant, (LazyLoadedValue<Ingredient>)new LazyLoadedValue(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)finalRepair))})));
                String name = file.getName().replace(".json", "");
                ITEM.register(name + "_knife", () -> new KnifeItem((Tier)mat, 1, -2.2f, new Item.Properties()));
                ITEM.register(name + "_saw", () -> new AxeItem((Tier)mat, 2.0f, -3.2f, new Item.Properties()));
                ITEM.register(name + "_mattock", () -> new MattockItem((Tier)mat, 0.5f, -3.0f, new Item.Properties()));
            }
            catch (Exception e) {
                DropTheRock.LOGGER.error("Error while loading custom item from {}", (Object)file.getName(), (Object)e);
            }
        }
    }

    public static Item.Properties getPropertiesIsModLoaded() {
        return new Item.Properties();
    }
}

