/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityDataProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("mc_talking", "entity_data");
    public static final Capability<EntityDataProvider> ENTITY_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<EntityDataProvider>(){});
    private String sessionToken = "";
    private final LazyOptional<EntityDataProvider> holder = LazyOptional.of(() -> this);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ENTITY_DATA_CAPABILITY) {
            return this.holder.cast();
        }
        return LazyOptional.empty();
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String token) {
        this.sessionToken = token;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("SessionToken", this.sessionToken);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.sessionToken = nbt.m_128461_("SessionToken");
    }

    public static LazyOptional<EntityDataProvider> getFromEntity(Entity entity) {
        if (entity == null) {
            return LazyOptional.empty();
        }
        return entity.getCapability(ENTITY_DATA_CAPABILITY);
    }
}

