/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.item;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.entity.visitor.VisitorCitizen;
import java.util.List;
import java.util.UUID;
import me.sshcrack.mc_talking.ConversationManager;
import me.sshcrack.mc_talking.McTalkingVoicechatPlugin;
import me.sshcrack.mc_talking.config.McTalkingConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenTalkingDevice
extends Item {
    private static final String TAG_TALKING_PLAYER = "talkingPlayer";
    private static final String TAG_MODEL_DATA = "CustomModelData";

    public CitizenTalkingDevice() {
        super(new Item.Properties().m_41487_(1));
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_TALKING_PLAYER)) {
            return false;
        }
        UUID uuid = tag.m_128342_(TAG_TALKING_PLAYER);
        return ConversationManager.isPlayerInConversation(uuid);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltipComponents, TooltipFlag pIsAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"item.mc_talking.talking_device.tooltip").m_130940_(ChatFormatting.GRAY));
        super.m_7373_(pStack, pLevel, tooltipComponents, pIsAdvanced);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (Math.random() <= 0.25) {
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_(TAG_TALKING_PLAYER)) {
                tag.m_128405_(TAG_MODEL_DATA, 0);
                return;
            }
            UUID uuid = tag.m_128342_(TAG_TALKING_PLAYER);
            boolean isActive = ConversationManager.isPlayerInConversation(uuid);
            tag.m_128405_(TAG_MODEL_DATA, isActive ? 1 : 0);
        }
    }

    public boolean onLeftClickEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity entity) {
        if (!(entity instanceof AbstractEntityCitizen)) {
            return false;
        }
        AbstractEntityCitizen citizen = (AbstractEntityCitizen)entity;
        if (player.m_9236_().m_5776_()) {
            return true;
        }
        if (entity instanceof VisitorCitizen) {
            player.m_213846_((Component)Component.m_237115_((String)"mc_talking.invalid_on_visitor").m_130940_(ChatFormatting.RED));
            return true;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        UUID playerId = serverPlayer.m_20148_();
        if (((String)McTalkingConfig.CONFIG.geminiApiKey.get()).isEmpty()) {
            serverPlayer.m_213846_((Component)Component.m_237113_((String)"No Gemini API key set. Minecolonies Talking Citizens is disabled.").m_130940_(ChatFormatting.RED));
            return true;
        }
        if (McTalkingVoicechatPlugin.vcApi == null) {
            serverPlayer.m_213846_((Component)Component.m_237113_((String)"Voice chat API is not initialized.").m_130940_(ChatFormatting.RED));
            return true;
        }
        AbstractEntityCitizen previousEntity = ConversationManager.getActiveEntity(playerId);
        if (previousEntity != null && previousEntity.m_20148_().equals(citizen.m_20148_())) {
            citizen.getNavigation().m_26573_();
            citizen.m_21563_().m_148051_((Entity)player);
            return true;
        }
        ConversationManager.startConversation(serverPlayer, citizen);
        CompoundTag tag = stack.m_41784_();
        tag.m_128362_(TAG_TALKING_PLAYER, playerId);
        tag.m_128405_(TAG_MODEL_DATA, 1);
        serverPlayer.m_213846_((Component)Component.m_237113_((String)("Started conversation with " + citizen.m_7755_().getString())).m_130940_(ChatFormatting.GREEN));
        citizen.getNavigation().m_26573_();
        citizen.m_21563_().m_148051_((Entity)player);
        return true;
    }
}

