/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.manager;

import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoderMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import me.sshcrack.mc_talking.McTalkingVoicechatPlugin;
import me.sshcrack.mc_talking.network.AiStatus;
import me.sshcrack.mc_talking.network.AiStatusPayload;
import me.sshcrack.mc_talking.util.AudioHelper;
import org.jetbrains.annotations.Nullable;

public class GeminiStream
implements Supplier<short[]> {
    public static final int FRAME_SIZE_SAMPLES = 960;
    private static final int TARGET_SAMPLE_RATE = 48000;
    private static final int MIN_BUFFER_SIZE_FOR_PITCH = 96000;
    private static final int MIN_FRAMES_BEFORE_PLAYBACK = 100;
    private final Queue<short[]> audioFrames = new ConcurrentLinkedQueue<short[]>();
    private final AudioChannel channel;
    @Nullable
    AudioPlayer player;
    private short[] remainingSamples = new short[0];
    private float pitchFactor = 1.0f;
    private boolean isPreBuffering = true;
    private int lastSampleRate = 48000;
    private final List<byte[]> incomingData = Collections.synchronizedList(new ArrayList());
    private int incomingDataSize = 0;
    private final UUID entityUuid;

    public GeminiStream(AudioChannel channel, UUID entityUuid) {
        this.channel = channel;
        this.entityUuid = entityUuid;
    }

    public void flushAudio() {
        if (this.incomingDataSize > 0) {
            this.processBufferedData(this.lastSampleRate, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addGeminiPcmWithPitch(byte[] data, int sampleRate) {
        this.lastSampleRate = sampleRate;
        if (data.length > 0) {
            List<byte[]> list = this.incomingData;
            synchronized (list) {
                this.incomingData.add(data);
                this.incomingDataSize += data.length;
            }
        }
        if (this.incomingDataSize >= 192000) {
            return this.processBufferedData(sampleRate, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processBufferedData(int sampleRate, boolean flushed) {
        byte[] combined;
        List<byte[]> list = this.incomingData;
        synchronized (list) {
            if (this.incomingDataSize == 0) {
                return false;
            }
            combined = new byte[this.incomingDataSize];
            int offset = 0;
            for (byte[] chunk : this.incomingData) {
                System.arraycopy(chunk, 0, combined, offset, chunk.length);
                offset += chunk.length;
            }
            this.incomingData.clear();
            this.incomingDataSize = 0;
        }
        short[] samples = new short[combined.length / 2];
        for (int i = 0; i < samples.length; ++i) {
            samples[i] = (short)(combined[i * 2] & 0xFF | combined[i * 2 + 1] << 8);
        }
        samples = AudioHelper.changePitch(samples, sampleRate, 2.0f);
        if (sampleRate != 48000) {
            samples = AudioHelper.resampleAudio(samples, sampleRate, 48000);
        }
        return this.processAudioSamples(samples, flushed);
    }

    private boolean processAudioSamples(short[] samples, boolean flushed) {
        if (this.remainingSamples.length > 0) {
            short[] combined = new short[this.remainingSamples.length + samples.length];
            System.arraycopy(this.remainingSamples, 0, combined, 0, this.remainingSamples.length);
            System.arraycopy(samples, 0, combined, this.remainingSamples.length, samples.length);
            samples = combined;
            this.remainingSamples = new short[0];
        }
        int frameCount = samples.length / 960;
        int remainingCount = samples.length % 960;
        for (int i = 0; i < frameCount; ++i) {
            short[] frame = new short[960];
            System.arraycopy(samples, i * 960, frame, 0, 960);
            this.audioFrames.add(frame);
        }
        if (remainingCount > 0) {
            this.remainingSamples = new short[remainingCount];
            System.arraycopy(samples, frameCount * 960, this.remainingSamples, 0, remainingCount);
        }
        if (this.player == null || this.player.isStopped()) {
            if (this.player != null) {
                this.player.stopPlaying();
            }
            if (!(this.audioFrames.isEmpty() || this.isPreBuffering && this.audioFrames.size() < 100 && !flushed)) {
                OpusEncoder encoder = McTalkingVoicechatPlugin.vcApi.createEncoder(OpusEncoderMode.AUDIO);
                this.player = McTalkingVoicechatPlugin.vcApi.createAudioPlayer(this.channel, encoder, (Supplier)this);
                this.isPreBuffering = false;
                this.player.startPlaying();
                return true;
            }
        }
        return false;
    }

    public void stop() {
        this.audioFrames.clear();
        this.remainingSamples = new short[0];
        this.isPreBuffering = true;
        if (this.player != null) {
            this.player.stopPlaying();
            this.player = null;
        }
    }

    public void close() {
        if (this.player != null) {
            this.player.stopPlaying();
        }
    }

    @Override
    public short[] get() {
        short[] frame = this.audioFrames.poll();
        if (frame != null) {
            return frame;
        }
        if (this.audioFrames.isEmpty()) {
            this.isPreBuffering = true;
            AiStatusPayload.sendToAll(new AiStatusPayload(this.entityUuid, AiStatus.LISTENING));
            return null;
        }
        return new short[960];
    }

    public void setPitch(float pitch) {
        this.pitchFactor = pitch;
    }
}

