/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.manager.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import java.util.ArrayList;
import me.sshcrack.mc_talking.manager.tools.FunctionAction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class GetInventoryAction
extends FunctionAction {
    public GetInventoryAction() {
        super("get_inventory", "Lists the current items in your inventory.");
    }

    @Override
    @NotNull
    public JsonObject execute(AbstractEntityCitizen citizen, IColony colony, JsonObject parameters) {
        JsonObject obj = new JsonObject();
        InventoryCitizen inv = citizen.getInventoryCitizen();
        for (int i = 0; i < inv.getSlots(); ++i) {
            CompoundTag displayTag;
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            JsonObject itemObj = new JsonObject();
            itemObj.addProperty("slot", (Number)i);
            ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            itemObj.addProperty("registry_id", registryName != null ? registryName.toString() : "unknown");
            itemObj.addProperty("name", stack.m_41611_().getString());
            itemObj.addProperty("count", (Number)stack.m_41613_());
            itemObj.addProperty("max_count", (Number)stack.m_41741_());
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128425_("display", 10) && (displayTag = tag.m_128469_("display")).m_128425_("Lore", 9)) {
                ListTag loreTag = displayTag.m_128437_("Lore", 8);
                ArrayList<String> loreLines = new ArrayList<String>();
                for (int j = 0; j < loreTag.size(); ++j) {
                    loreLines.add(loreTag.m_128778_(j));
                }
                itemObj.addProperty("lore", String.join((CharSequence)"\n", loreLines));
            }
            obj.add("item_" + i, (JsonElement)itemObj);
        }
        return obj;
    }
}

