/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.network;

import java.util.UUID;
import java.util.function.Supplier;
import me.sshcrack.mc_talking.ConversationManager;
import me.sshcrack.mc_talking.network.AiStatus;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class AiStatusPayload {
    public static final String PROTOCOL_VERSION = "1";
    public static final ResourceLocation CHANNEL_ID = new ResourceLocation("mc_talking", "ai_status");
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)CHANNEL_ID, () -> "1", "1"::equals, "1"::equals);
    private final UUID citizen;
    private final AiStatus status;

    public AiStatusPayload(UUID citizen, AiStatus status) {
        this.citizen = citizen;
        this.status = status;
    }

    public UUID citizen() {
        return this.citizen;
    }

    public AiStatus status() {
        return this.status;
    }

    public static void encode(AiStatusPayload msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.citizen);
        buf.m_130068_((Enum)msg.status);
    }

    public static AiStatusPayload decode(FriendlyByteBuf buf) {
        UUID citizen = buf.m_130259_();
        AiStatus status = (AiStatus)buf.m_130066_(AiStatus.class);
        return new AiStatusPayload(citizen, status);
    }

    public static void handle(AiStatusPayload msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ConversationManager.updateAiStatus(msg.citizen, msg.status));
        ctx.get().setPacketHandled(true);
    }

    public static void registerMessages() {
        CHANNEL.registerMessage(0, AiStatusPayload.class, AiStatusPayload::encode, AiStatusPayload::decode, AiStatusPayload::handle);
    }

    public static void sendToAll(AiStatusPayload packet) {
        CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }
}

