/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.sshcrack.mc_talking.config.McTalkingConfig;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;

public class EntityTrackingManager {
    private final Map<UUID, UUID> playerLookingAt = new HashMap<UUID, UUID>();
    private final Map<UUID, Integer> lookDuration = new HashMap<UUID, Integer>();
    private final Map<UUID, UUID> previousEntityLookedAt = new HashMap<UUID, UUID>();
    private final Map<UUID, Long> lastEntitySwitchTime = new HashMap<UUID, Long>();

    public AbstractEntityCitizen findEntityPlayerLookingAt(ServerPlayer player) {
        Level level = player.level();
        return (AbstractEntityCitizen)level.getNearestEntity(AbstractEntityCitizen.class, TargetingConditions.forNonCombat().range(((Double)McTalkingConfig.CONFIG.activationDistance.get()).doubleValue()), (LivingEntity)player, player.getX(), player.getY(), player.getZ(), player.getBoundingBox().inflate(((Double)McTalkingConfig.CONFIG.activationDistance.get()).doubleValue()));
    }

    public void handleNewTargetEntity(UUID playerId, UUID currentTargetId, UUID previousTargetId) {
        long lastSwitchTime;
        long currentTime = System.currentTimeMillis();
        UUID previousEntityId = this.previousEntityLookedAt.get(playerId);
        if (previousEntityId != null && previousEntityId.equals(currentTargetId) && currentTime - (lastSwitchTime = this.lastEntitySwitchTime.getOrDefault(playerId, 0L).longValue()) < (long)((Integer)McTalkingConfig.CONFIG.lookToleranceMs.get()).intValue()) {
            int previousDuration = this.lookDuration.getOrDefault(playerId, 0);
            this.lookDuration.put(playerId, Math.max(0, previousDuration - 5));
            this.playerLookingAt.put(playerId, currentTargetId);
            return;
        }
        this.playerLookingAt.put(playerId, currentTargetId);
        this.previousEntityLookedAt.put(playerId, previousTargetId);
        this.lastEntitySwitchTime.put(playerId, currentTime);
        this.lookDuration.put(playerId, 0);
    }

    public void resetPlayerLookTracking(UUID playerId) {
        UUID previousTargetId = this.playerLookingAt.get(playerId);
        if (previousTargetId != null) {
            this.previousEntityLookedAt.put(playerId, previousTargetId);
            this.lastEntitySwitchTime.put(playerId, System.currentTimeMillis());
        }
        this.playerLookingAt.remove(playerId);
        this.lookDuration.remove(playerId);
    }

    public UUID getEntityPlayerLookingAt(UUID playerId) {
        return this.playerLookingAt.get(playerId);
    }

    public int getLookDuration(UUID playerId) {
        return this.lookDuration.getOrDefault(playerId, 0);
    }

    public int incrementLookDuration(UUID playerId) {
        int currentDuration = this.lookDuration.getOrDefault(playerId, 0) + 1;
        this.lookDuration.put(playerId, currentDuration);
        return currentDuration;
    }

    public void cleanup() {
        this.playerLookingAt.clear();
        this.lookDuration.clear();
        this.previousEntityLookedAt.clear();
        this.lastEntitySwitchTime.clear();
    }
}

