/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.sshcrack.mc_talking.ConversationManager;
import me.sshcrack.mc_talking.McTalking;
import me.sshcrack.mc_talking.config.McTalkingConfig;
import me.sshcrack.mc_talking.manager.TalkingManager;

@ForgeVoicechatPlugin
public class McTalkingVoicechatPlugin
implements VoicechatPlugin {
    public static VoicechatServerApi vcApi;
    private final Map<UUID, ScheduledFuture<?>> silenceTimeouts = new ConcurrentHashMap();
    private final Map<UUID, Long> lastVoiceActivity = new ConcurrentHashMap<UUID, Long>();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private static final long SILENCE_DURATION_MS = 1000L;
    private static final long SILENCE_INTERVAL_MS = 20L;
    private static final long VOICE_INACTIVITY_THRESHOLD_MS = 200L;

    public String getPluginId() {
        return "mc_talking";
    }

    public void initialize(VoicechatApi api) {
        McTalking.LOGGER.info("Initializing Voicechat Plugin");
    }

    public void onServerStart(VoicechatServerStartedEvent event) {
        McTalking.LOGGER.info("Voicechat Server Started");
        vcApi = event.getVoicechat();
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(MicrophonePacketEvent.class, this::handleMicPacket);
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStart);
    }

    public void handleMicPacket(MicrophonePacketEvent event) {
        VoicechatConnection sender = event.getSenderConnection();
        if (sender == null) {
            return;
        }
        MicrophonePacket packet = (MicrophonePacket)event.getPacket();
        if (packet.isWhispering()) {
            return;
        }
        if (sender.isDisabled()) {
            return;
        }
        ServerPlayer vcPlayer = sender.getPlayer();
        if (sender.isInGroup() && !((Boolean)McTalkingConfig.CONFIG.respondInGroups.get()).booleanValue()) {
            return;
        }
        net.minecraft.server.level.ServerPlayer player = (net.minecraft.server.level.ServerPlayer)vcPlayer.getPlayer();
        AbstractEntityCitizen entity = ConversationManager.getActiveEntity(player.getUUID());
        if (entity == null) {
            return;
        }
        TalkingManager manager = ConversationManager.getClientForEntity(entity.getUUID());
        if (manager == null) {
            return;
        }
        UUID entityId = entity.getUUID();
        byte[] opusData = packet.getOpusEncodedData();
        boolean hasVoiceActivity = this.hasVoiceActivity(opusData);
        if (hasVoiceActivity) {
            this.lastVoiceActivity.put(entityId, System.currentTimeMillis());
            manager.promptAudioOpus(opusData);
            this.cancelSilenceTask(entityId);
        } else {
            Long lastActivity = this.lastVoiceActivity.get(entityId);
            long currentTime = System.currentTimeMillis();
            if (lastActivity != null && currentTime - lastActivity > 200L && !this.silenceTimeouts.containsKey(entityId)) {
                this.scheduleSilenceTask(entityId, manager);
            }
        }
    }

    private boolean hasVoiceActivity(byte[] opusData) {
        return opusData != null && opusData.length > 1;
    }

    private void scheduleSilenceTask(UUID entityId, TalkingManager manager) {
        if (this.silenceTimeouts.containsKey(entityId)) {
            return;
        }
        ScheduledFuture<?> future = this.executor.scheduleAtFixedRate(() -> {
            Long lastActivity = this.lastVoiceActivity.get(entityId);
            long currentTime = System.currentTimeMillis();
            if (lastActivity != null && currentTime - lastActivity > 200L) {
                short[] hummingAudio = this.generateLowVolumeHumming(960);
                manager.promptAudioRaw(hummingAudio);
            } else {
                this.cancelSilenceTask(entityId);
            }
        }, 0L, 20L, TimeUnit.MILLISECONDS);
        this.executor.schedule(() -> this.cancelSilenceTask(entityId), 1000L, TimeUnit.MILLISECONDS);
        this.silenceTimeouts.put(entityId, future);
    }

    private short[] generateLowVolumeHumming(int length) {
        short[] audio = new short[length];
        double frequency = 110.0;
        double amplitude = 10.0;
        double sampleRate = 48000.0;
        for (int i = 0; i < length; ++i) {
            double time = (double)i / sampleRate;
            audio[i] = (short)(amplitude * Math.sin(Math.PI * 2 * frequency * time));
        }
        return audio;
    }

    private void cancelSilenceTask(UUID entityId) {
        ScheduledFuture<?> future = this.silenceTimeouts.remove(entityId);
        if (future != null) {
            future.cancel(true);
        }
    }
}

