/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.config;

import me.sshcrack.mc_talking.config.AvailableAI;
import me.sshcrack.mc_talking.config.ModalityModes;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class McTalkingConfig {
    public static final McTalkingConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public final ModConfigSpec.ConfigValue<String> geminiApiKey;
    public final ModConfigSpec.ConfigValue<AvailableAI> currentAiModel;
    public final ModConfigSpec.ConfigValue<String> language;
    public final ModConfigSpec.ConfigValue<Boolean> respondInGroups;
    public final ModConfigSpec.ConfigValue<Integer> lookDurationTicks;
    public final ModConfigSpec.ConfigValue<Integer> lookToleranceMs;
    public final ModConfigSpec.ConfigValue<Double> activationDistance;
    public final ModConfigSpec.ConfigValue<Boolean> useTalkingDevice;
    public final ModConfigSpec.ConfigValue<Boolean> enableFunctionWorkaround;
    public final ModConfigSpec.ConfigValue<Integer> maxConcurrentAgents;
    public final ModConfigSpec.ConfigValue<Double> maxConversationDistance;
    public final ModConfigSpec.ConfigValue<ModalityModes> modality;

    public McTalkingConfig(ModConfigSpec.Builder builder) {
        this.geminiApiKey = builder.comment("API Configuration").gameRestart().comment("This key is used to authenticate with the Gemini API. You can get one at https://aistudio.google.com/apikey").define("gemini_key", (Object)"");
        this.currentAiModel = builder.gameRestart().comment("What kind of AI model to use. Flash2.5 is more advanced, more expensive but has more voices as well. Flash2.5 burns the free tokens fast. Flash2.5 can only execute functions (for example dropping items, getting information about the colony) when Google Search is enabled.").defineEnum("ai_model", (Enum)AvailableAI.Flash2_5);
        this.enableFunctionWorkaround = builder.gameRestart().comment("Enables the Google Search so Flash2.5 can execute functions. Google Search will ONLY be enabled for Flash2.5.").define("function_workaround", true);
        this.language = builder.comment("Language Configuration").gameRestart().comment("The language the AI should use to speak").define("language", (Object)"en-US");
        this.respondInGroups = builder.gameRestart().comment("Interaction Configuration").comment("Whether the citizens should respond if the player is in a group or not.").define("respond_in_group", false);
        this.lookDurationTicks = builder.gameRestart().comment("How long the player needs to look at an entity before activating (in ticks, 20 ticks = 1 second)").define("look_duration_ticks", (Object)20);
        this.lookToleranceMs = builder.gameRestart().comment("Tolerance time in milliseconds when something walks between player and target").define("look_tolerance_ms", (Object)500);
        this.activationDistance = builder.gameRestart().comment("Distance at which the player can talk to when looking at them the citizen").define("activation_distance", (Object)3.0);
        this.useTalkingDevice = builder.gameRestart().comment("If true, citizens will only respond to the talking device item; if false, looking at them will work").define("use_talking_device", true);
        this.maxConcurrentAgents = builder.gameRestart().comment("Resource Management").comment("Maximum number of AI agents that can be activated at once").define("max_concurrent_agents", (Object)3, e -> e == null || (Integer)e > 0);
        this.maxConversationDistance = builder.gameRestart().comment("Maximum distance the player can be from a citizen before the conversation is ended").define("max_conversation_distance", (Object)8.0);
        this.modality = builder.gameRestart().comment("The modality of the AI. If true, the AI will use text and audio, if false, it will only use text. Gemini Live 2.5 doesn't support text only output.").defineEnum("ai_modality", (Enum)ModalityModes.AUDIO);
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(McTalkingConfig::new);
        CONFIG = (McTalkingConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

