/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.item;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.entity.visitor.VisitorCitizen;
import java.util.List;
import java.util.UUID;
import me.sshcrack.mc_talking.ConversationManager;
import me.sshcrack.mc_talking.McTalkingVoicechatPlugin;
import me.sshcrack.mc_talking.config.McTalkingConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CitizenTalkingDevice
extends Item {
    public CitizenTalkingDevice() {
        super(new Item.Properties().stacksTo(1).component(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY));
    }

    public boolean isFoil(ItemStack stack) {
        if (stack.get(DataComponents.CUSTOM_DATA) == null) {
            return false;
        }
        CompoundTag comp = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
        if (!comp.contains("talkingPlayer")) {
            return false;
        }
        UUID uuid = comp.getUUID("talkingPlayer");
        return ConversationManager.isPlayerInConversation(uuid);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.mc_talking.talking_device.tooltip").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (Math.random() <= 0.25) {
            CompoundTag comp = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
            if (!comp.contains("talkingPlayer")) {
                stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0));
                return;
            }
            UUID uuid = comp.getUUID("talkingPlayer");
            boolean isActive = ConversationManager.isPlayerInConversation(uuid);
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(isActive ? 1 : 0));
        }
    }

    public boolean onLeftClickEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity entity) {
        if (!(entity instanceof AbstractEntityCitizen)) {
            return false;
        }
        AbstractEntityCitizen citizen = (AbstractEntityCitizen)entity;
        if (player.level().isClientSide()) {
            return true;
        }
        if (entity instanceof VisitorCitizen) {
            player.sendSystemMessage((Component)Component.translatable((String)"mc_talking.invalid_on_visitor").withStyle(ChatFormatting.RED));
            return true;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        UUID playerId = serverPlayer.getUUID();
        if (((String)McTalkingConfig.CONFIG.geminiApiKey.get()).isEmpty()) {
            serverPlayer.sendSystemMessage((Component)Component.literal((String)"No Gemini API key set. Minecolonies Talking Citizens is disabled.").withStyle(ChatFormatting.RED));
            return true;
        }
        if (McTalkingVoicechatPlugin.vcApi == null) {
            serverPlayer.sendSystemMessage((Component)Component.literal((String)"Voice chat API is not initialized.").withStyle(ChatFormatting.RED));
            return true;
        }
        AbstractEntityCitizen previousEntity = ConversationManager.getActiveEntity(playerId);
        if (previousEntity != null && previousEntity.getUUID().equals(citizen.getUUID())) {
            citizen.getNavigation().stop();
            citizen.getLookControl().setLookAt((Entity)player);
            return true;
        }
        ConversationManager.startConversation(serverPlayer, citizen);
        CustomData compD = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (compD == null) {
            compD = CustomData.EMPTY;
        }
        CompoundTag comp = compD.copyTag();
        comp.putUUID("talkingPlayer", playerId);
        stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(1));
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)comp));
        serverPlayer.sendSystemMessage((Component)Component.literal((String)("Started conversation with " + citizen.getName().getString())).withStyle(ChatFormatting.GREEN));
        citizen.getNavigation().stop();
        citizen.getLookControl().setLookAt((Entity)player);
        return true;
    }
}

