/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.mixin;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.core.colony.CitizenData;
import me.sshcrack.mc_talking.ConversationManager;
import me.sshcrack.mc_talking.manager.CitizenContextUtils;
import me.sshcrack.mc_talking.manager.TalkingManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CitizenData.class})
public class CitizenDataMixin {
    @Inject(method={"setVisibleStatus"}, at={@At(value="HEAD")})
    private void mc_talking$onSetVisibleStatus(VisibleCitizenStatus status, CallbackInfo ci) {
        if (status == null) {
            return;
        }
        CitizenData data = (CitizenData)CitizenData.class.cast(this);
        TalkingManager client = ConversationManager.getClientForEntity(data.getUUID());
        if (client == null) {
            return;
        }
        String newStatusPrompt = String.format("You are now %s", CitizenContextUtils.formatStatus(status, (ICitizenData)data));
        client.promptSystemText(newStatusPrompt);
    }
}

