/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.UUID;
import me.sshcrack.mc_talking.ConversationManager;
import me.sshcrack.mc_talking.McTalking;
import me.sshcrack.mc_talking.config.McTalkingConfig;
import me.sshcrack.mc_talking.item.CitizenTalkingDevice;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class ServerEventHandler {
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.forNonCombat().ignoreLineOfSight();
    private int tickCounter = 0;

    @SubscribeEvent
    public void onServerStart(ServerStartingEvent event) {
        if (!((String)McTalkingConfig.CONFIG.geminiApiKey.get()).isEmpty()) {
            return;
        }
        McTalking.LOGGER.error("======================");
        McTalking.LOGGER.error("Gemini API key not set. McTalking is disabled.");
        McTalking.LOGGER.error("======================");
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        ConversationManager.cleanup();
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        for (ItemStack item : player.getInventory().items) {
            if (!(item.getItem() instanceof CitizenTalkingDevice)) continue;
            item.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0));
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ConversationManager.endConversation(player.getUUID(), false);
        }
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        ++this.tickCounter;
        if (this.tickCounter % 5 != 0) {
            return;
        }
        if (event.getServer().getPlayerList().getPlayers().isEmpty()) {
            return;
        }
        for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
            UUID playerId = player.getUUID();
            UUID citizenId = ConversationManager.getPlayerConversationPartner(playerId);
            if (citizenId != null) {
                this.checkConversationDistance(player, citizenId);
                continue;
            }
            if (((Boolean)McTalkingConfig.CONFIG.useTalkingDevice.get()).booleanValue() && !this.isHoldingTalkingDevice(player)) continue;
            this.processPlayerLooking(player);
        }
    }

    private void checkConversationDistance(ServerPlayer player, UUID citizenId) {
        AbstractEntityCitizen activeEntity = ConversationManager.getActiveEntityForPlayer(player.getUUID());
        if (activeEntity == null || !activeEntity.isAlive()) {
            ConversationManager.endConversation(player.getUUID(), false);
            return;
        }
        double distanceSquared = player.distanceToSqr((Entity)activeEntity);
        if (distanceSquared > (Double)McTalkingConfig.CONFIG.maxConversationDistance.get() * (Double)McTalkingConfig.CONFIG.maxConversationDistance.get()) {
            ConversationManager.endConversation(player.getUUID(), true);
        }
    }

    private void processPlayerLooking(ServerPlayer player) {
        Entity targetEntity;
        HitResult hitResult = player.pick(20.0, 0.0f, false);
        UUID playerId = player.getUUID();
        if (hitResult.getType() == HitResult.Type.ENTITY && (targetEntity = ((EntityHitResult)hitResult).getEntity()) instanceof AbstractEntityCitizen) {
            AbstractEntityCitizen citizen = (AbstractEntityCitizen)targetEntity;
            double distance = player.distanceToSqr(targetEntity);
            if (distance <= (Double)McTalkingConfig.CONFIG.activationDistance.get() * (Double)McTalkingConfig.CONFIG.activationDistance.get()) {
                this.processLookingAtCitizen(player, citizen);
                return;
            }
        }
        ConversationManager.setPlayerLookTarget(playerId, null);
    }

    private void processLookingAtCitizen(ServerPlayer player, AbstractEntityCitizen citizen) {
        UUID playerId = player.getUUID();
        UUID citizenId = citizen.getUUID();
        ConversationManager.setPlayerLookTarget(playerId, citizenId);
        ConversationManager.incrementLookDuration(playerId);
        if (ConversationManager.getPlayerLookDuration(playerId) >= (Integer)McTalkingConfig.CONFIG.lookDurationTicks.get()) {
            boolean playerIsAlone = this.isPlayerAlone(player);
            if (playerIsAlone || ((Boolean)McTalkingConfig.CONFIG.respondInGroups.get()).booleanValue()) {
                ConversationManager.startConversation(player, citizen);
                for (ItemStack item : player.getInventory().items) {
                    if (!(item.getItem() instanceof CitizenTalkingDevice) || player.getInventory().selected != player.getInventory().findSlotMatchingItem(item)) continue;
                    item.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(1));
                    break;
                }
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"mc_talking.group_disabled").withStyle(ChatFormatting.YELLOW));
                ConversationManager.setPlayerLookTarget(playerId, null);
            }
        }
    }

    private boolean isHoldingTalkingDevice(ServerPlayer player) {
        ItemStack heldItem = player.getMainHandItem();
        return heldItem.getItem() instanceof CitizenTalkingDevice;
    }

    private boolean isPlayerAlone(ServerPlayer player) {
        AABB boundingBox = player.getBoundingBox().inflate(5.0);
        int nearbyPlayers = player.level().getNearbyEntities(ServerPlayer.class, TARGETING_CONDITIONS, (LivingEntity)player, boundingBox).size();
        return nearbyPlayers <= 1;
    }
}

