/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.gson;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.sshcrack.mc_talking.gson.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BidiGenerateContentSetup {
    @NotNull
    public String model;
    @NotNull
    public GenerationConfig generationConfig = new GenerationConfig();
    public SystemInstruction systemInstruction;
    public List<Tool> tools = new ArrayList<Tool>();
    public SessionResumptionConfig sessionResumption;
    public RealtimeInputConfig realtimeInputConfig;

    public BidiGenerateContentSetup(@NotNull String model) {
        this.model = model;
    }

    public static class GenerationConfig {
        @Nullable
        public String candidateCount;
        @Nullable
        public String maxOutputTokens;
        @Nullable
        public String temperature;
        @Nullable
        public String topP;
        @Nullable
        public String topK;
        @Nullable
        public String presencePenalty;
        @Nullable
        public String frequencyPenalty;
        @Nullable
        public List<String> responseModalities;
        @Nullable
        public SpeechConfig speechConfig;
        @Nullable
        public Object mediaResolution;

        public static class SpeechConfig {
            @Nullable
            public String language_code;
            @Nullable
            public VoiceConfig voice_config;

            public static class PrebuiltVoiceConfig {
                @Nullable
                public String voice_name;
            }

            public static class VoiceConfig {
                @Nullable
                public PrebuiltVoiceConfig prebuiltVoiceConfig;
            }
        }
    }

    public static class RealtimeInputConfig {
        public TurnCoverage turnCoverage;

        public static enum TurnCoverage {
            TURN_COVERAGE_UNSPECIFIED,
            TURN_INCLUDES_ONLY_ACTIVITY,
            TURN_INCLUDES_ALL_INPUT;

        }
    }

    public static class SessionResumptionConfig {
        public String handle;

        public SessionResumptionConfig(@NotNull String handle) {
            this.handle = handle;
        }

        public SessionResumptionConfig() {
            this.handle = null;
        }
    }

    public static class Tool {
        public List<FunctionDeclaration> functionDeclarations = new ArrayList<FunctionDeclaration>();
        public Object googleSearch = null;

        public static Tool googleSearch() {
            Tool tool = new Tool();
            tool.functionDeclarations = null;
            tool.googleSearch = new Object();
            return tool;
        }

        public static class FunctionDeclaration {
            @NotNull
            public String name;
            @NotNull
            public String description;
            public Property parameters;

            public FunctionDeclaration(@NotNull String name, @NotNull String description) {
                this.name = name;
                this.description = description;
            }
        }
    }

    public static class SystemInstruction {
        public List<Part> parts = new ArrayList<Part>();

        public static class Part {
            @NotNull
            public String text;

            public Part(@NotNull String text) {
                this.text = text;
            }
        }
    }
}

