/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.manager.tools;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.colony.managers.interfaces.IVisitorManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.buildings.modules.TavernBuildingModule;
import com.minecolonies.core.colony.interactionhandling.RecruitmentInteraction;
import java.util.List;
import me.sshcrack.mc_talking.manager.tools.FunctionAction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class LeaveColonyAction
extends FunctionAction {
    private static final String TAG_RECRUIT_COST = "rcost";
    private static final String TAG_RECRUIT_COST_QTY = "rcostqty";

    public LeaveColonyAction() {
        super("leave_colony", "You leave the colony and become a visitor. Use this ONLY if you are REALLY unhappy and the manager doesn't care about you.");
    }

    @Override
    @NotNull
    public JsonObject execute(AbstractEntityCitizen citizen, IColony colony, JsonObject parameters) {
        ICitizenManager citizenManager = colony.getCitizenManager();
        IVisitorManager visitorManager = colony.getVisitorManager();
        IBuilding building = colony.getBuildingManager().getFirstBuildingMatching(e -> e.getBuildingType().equals(ModBuildings.tavern.get()));
        if (building == null) {
            JsonObject invalidReturn = new JsonObject();
            invalidReturn.addProperty("error", "No tavern found in the colony.");
            return invalidReturn;
        }
        TavernBuildingModule module = (TavernBuildingModule)building.getFirstModuleOccurance(TavernBuildingModule.class);
        if (module == null) {
            JsonObject invalidReturn = new JsonObject();
            invalidReturn.addProperty("error", "No tavern found in the colony.");
            return invalidReturn;
        }
        ICitizenData data = citizen.getCitizenData();
        Level level = citizen.level();
        BlockPos pos = citizen.blockPosition();
        CompoundTag citizenTag = (CompoundTag)data.serializeNBT((HolderLookup.Provider)level.registryAccess());
        ItemStack recruitCost = Items.DIAMOND.getDefaultInstance();
        recruitCost.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"mc_talking.recruit_lore"))));
        recruitCost.setCount(16);
        citizenManager.removeCivilian((ICivilianData)data);
        citizen.remove(Entity.RemovalReason.DISCARDED);
        IVisitorData visitorData = (IVisitorData)visitorManager.createAndRegisterCivilianData();
        citizenTag.remove("job");
        citizenTag.put(TAG_RECRUIT_COST, recruitCost.save((HolderLookup.Provider)level.registryAccess()));
        citizenTag.putInt(TAG_RECRUIT_COST_QTY, recruitCost.getCount());
        BlockPosUtil.write((CompoundTag)citizenTag, (String)"sit", (BlockPos)BlockPos.ZERO);
        citizenTag.putInt("id", visitorData.getId());
        visitorData.deserializeNBT((HolderLookup.Provider)level.registryAccess(), (Tag)citizenTag);
        visitorData.setHomeBuilding(building);
        visitorManager.spawnOrCreateCivilian((ICivilianData)visitorData, level, pos, true);
        module.getExternalCitizens().add(visitorData.getId());
        visitorData.triggerInteraction((IInteractionResponseHandler)new RecruitmentInteraction((Component)Component.translatable((String)("com.minecolonies.coremod.gui.chat.recruitstory" + (level.random.nextInt(5) + 1)), (Object[])new Object[]{visitorData.getName().split(" ")[0]}), (IChatPriority)ChatPriority.IMPORTANT));
        JsonObject obj = new JsonObject();
        obj.addProperty("success", Boolean.valueOf(true));
        return obj;
    }
}

